package com.el.coordinator.boot.fsm.model.dto;

import com.el.coordinator.boot.fsm.common.FileTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 文件信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
@Data
public class FileObjDTO<T> implements Serializable {

    /**
     * 文件编码，文件服务器上的文件唯一标识
     */
    private String fileCode;

    /**
     * 文件原名称
     */
    private String originalName;

    /**
     * 文件大小，字节B
     */
    private Long fileSize;

    /**
     * 文件名后缀
     */
    private String suffix;

    /**
     * 文件内容类型，mime-type
     */
    private String mimeType;

    /**
     * 常见的文件类型
     */
    private FileTypeEnum fileType;

    /**
     * 上传时间
     */
    private LocalDateTime uploadTime;

    /**
     * 下载路径
     */
    private String downloadPath;

    /**
     * 桶名称
     */
    private String bucketName;

    /**
     * 外部可访问的完整链接
     */
    private String url;

    /**
     * 文件路径
     */
    private String filePath;

    /**
     * 扩展自定义属性1
     */
    private String attribute1;

    /**
     * 扩展自定义属性1
     */
    private String attribute2;

    /**
     * 扩展自定义属性3
     */
    private String attribute3;

    /**
     * 扩展自定义属性4
     */
    private String attribute4;

    /**
     * 扩展自定义属性5
     */
    private String attribute5;

    /**
     * 扩展信息
     */
    private T extraInfo;
}
