package com.el.coordinator.boot.fsm.service.importdata;

import com.el.coordinator.boot.fsm.model.vo.ImportResultRespVO;

import java.io.Serializable;
import java.util.List;

/**
 * 数据导入接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/3
 * @deprecated 请使用 {@link com.elitescloud.boot.excel.common.DataImport}
 */
@Deprecated(forRemoval = true)
public interface DataImport<T extends Serializable> {

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    String getTmplCode();

    /**
     * 导入数据
     *
     * @param dataList      数据列表
     * @param startRowIndex 开始行索引
     * @return 导入结果
     */
    ImportResultRespVO.SyncResult execute(List<T> dataList, int startRowIndex);

    /**
     * 每次取的数据量
     *
     * @return 数据条数
     */
    default Integer stepSize() {
        return null;
    }
}
