package com.el.coordinator.boot.fsm.support.handler;

import com.alibaba.excel.write.handler.AbstractSheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.el.coordinator.file.business.dto.TmplDTO;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Sheet;

/**
 * 数据导出sheet handler.
 * <p>
 * 处理导出时数据未从指定行开始导出
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/01
 */
@Slf4j
public class ExportSheetWriterHandler extends AbstractSheetWriteHandler {

    private final TmplDTO tmplDTO;

    public ExportSheetWriterHandler(TmplDTO tmplDTO) {
        this.tmplDTO = tmplDTO;
    }

    @SneakyThrows
    @Override
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        if (tmplDTO == null) {
            return;
        }
        Integer headNum = tmplDTO.getHeadRow();
        if (headNum == null || headNum < 1) {
            return;
        }

        Sheet sheet = writeSheetHolder.getCachedSheet();
        if (sheet == null) {
            log.warn("未获取到sheet");
            return;
        }

        // 删除字段类型行
        removeFieldTypeRow(sheet, headNum, tmplDTO.getFieldTypeRow());

        // 删除headRow之后的行
        int lastRowIndex = sheet.getLastRowNum();
        if (lastRowIndex + 1 <= headNum) {
            // 没有需要处理的行
            return;
        }
        for (int i = headNum; i <= lastRowIndex; i++) {
            removeRow(sheet, i);
        }
    }

    private void removeFieldTypeRow(Sheet sheet, int headRow, Integer fieldTypeRow) {
        if (fieldTypeRow == null || fieldTypeRow > headRow) {
            return;
        }
        removeRow(sheet, fieldTypeRow - 1);
    }

    private void removeRow(Sheet sheet, Integer rowIndex) {
        var row = sheet.getRow(rowIndex);
        if (row == null) {
            return;
        }
        sheet.removeRow(row);
    }
}
