/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.authorization.api.provider.AuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.config.SsoConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.SystemConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.ServletOAuth2ServerConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.ServletSingleConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.JwtTokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.CacheUserAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.DefaultAuthenticationCheckServiceImpl;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.DefaultAuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.web.controller.LoginController;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.nimbusds.jose.jwk.RSAKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableWebSecurity
@Import(value={ServletSingleConfig.class, ServletOAuth2ServerConfig.class, SystemConfig.class, SsoConfig.class})
public class AuthorizationAutoConfiguration {
    private static final Logger log = LogManager.getLogger(AuthorizationAutoConfiguration.class);
    private final AuthorizationProperties authorizationProperties;

    public AuthorizationAutoConfiguration(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
        Assert.notNull((Object)authorizationProperties.getType(), (String)"\u672a\u77e5\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f");
        log.info("\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f\uff1a{}", (Object)authorizationProperties.getType());
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenGenerator tokenGenerator(RSAKey rsaKey, OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer) {
        JwtEncoder jwtEncoder = JwtUtil.buildJwtEncoder((RSAKey)rsaKey);
        JwtTokenGenerator jwtTokenGenerator = new JwtTokenGenerator(this.authorizationProperties, jwtEncoder);
        jwtTokenGenerator.setTokenCustomizer(jwtCustomizer);
        return jwtTokenGenerator;
    }

    @Bean
    public OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer() {
        return context -> {
            Object principal = context.getPrincipal().getPrincipal();
            JwtClaimsSet.Builder claims = context.getClaims();
            if (principal instanceof GeneralUserDetails) {
                GeneralUserDetails userDetails = (GeneralUserDetails)principal;
                claims.claim("yst_un", (Object)userDetails.getUsername());
                claims.claim("yst_ui", (Object)userDetails.getUser().getId());
                if (userDetails.getTenant() != null) {
                    claims.claim("yst_ti", (Object)userDetails.getTenant().getId());
                }
                claims.claim("yst_pt", (Object)"us");
            } else {
                claims.claim("yst_pt", (Object)"cli");
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationService authenticationService(ObjectProvider<AuthenticationCallable> authenticationCallableObjectProvider) {
        return new DefaultAuthenticationService(DelegateAuthenticationCallable.getInstance(authenticationCallableObjectProvider));
    }

    @Bean
    @ConditionalOnBean(value={AuthenticationService.class})
    public LoginController loginSupportController(AuthenticationService authenticationService) {
        return new LoginController(authenticationService);
    }

    @Bean
    public AuthenticationCheckService defaultAuthenticationCheckService(ConfigProperties configProperties) {
        return new DefaultAuthenticationCheckServiceImpl(configProperties);
    }

    @Bean
    public AuthenticationCallable authenticationCallableCacheUser(AuthenticationCache authenticationCache) {
        return new CacheUserAuthenticationCallable(this.authorizationProperties, authenticationCache);
    }
}

