/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.CaptchaProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.messenger.RmiMsgCarrierDubboService;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.support.RmiOrgUserEmpBuRpcService;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitescloud.cloudt.authorization.api.provider.provider.sms.SmsCodeProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatProvider;
import com.elitescloud.cloudt.authorization.api.provider.web.controller.LoginSupportController;
import com.elitescloud.cloudt.common.condition.ConditionalOnRpc;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={ConfigOnRpc.class})
public class LoginSupportConfig {
    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public LoginSupportConfig(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(this.configProperties);
    }

    @Bean
    public LoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new LoginSupportController(loginSupportProvider);
    }

    @ConditionalOnBean(value={RmiSysUserRpcService.class})
    @Bean
    public UserDetailManager userDetailManager(RmiSysUserRpcService rmiSysUserRpcService) {
        return new UserDetailManager(this.authorizationProperties, this.configProperties, rmiSysUserRpcService);
    }

    @ConditionalOnBean(value={RedisHelper.class, RmiMsgCarrierDubboService.class})
    @Bean
    public SmsCodeProvider smsCodeProvider(RedisHelper redisHelper, RmiMsgCarrierDubboService rmiMsgCarrierDubboService) {
        return new SmsCodeProvider(redisHelper, this.configProperties, rmiMsgCarrierDubboService);
    }

    @ConditionalOnBean(value={RedisHelper.class})
    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    @Bean
    public WechatProvider wechatProvider(WechatProperties wechatProperties) {
        return new WechatProvider(wechatProperties);
    }

    @ConditionalOnRpc
    static class ConfigOnRpc {
        ConfigOnRpc() {
        }

        @Bean
        public RmiMsgCarrierDubboService rmiMsgCarrierDubboService() {
            return new RmiMsgCarrierDubboService();
        }

        @Bean
        public RmiOrgUserEmpBuRpcService rmiOrgUserEmpBuRpcService() {
            return new RmiOrgUserEmpBuRpcService();
        }

        @Bean
        public RmiSysUserRpcService rmiSysUserRpcService() {
            return new RmiSysUserRpcService();
        }
    }
}

