/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.OAuth2ClientProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.support.OAuth2ClientUserResolver;
import com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.support.userresolver.DefaultOAuth2CLientUserResolver;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.web.controller.OAuth2LoginSupportController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServletOAuth2ClientConfig {
    private static final Logger log = LogManager.getLogger(ServletOAuth2ClientConfig.class);
    private final AuthorizationProperties authorizationProperties;

    public ServletOAuth2ClientConfig(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Bean
    public OAuth2ClientProvider oAuth2ClientProvider(TokenGenerator tokenGenerator, AuthenticationCache authenticationCache, ObjectProvider<OAuth2ClientUserResolver> clientUserResolverObjectProvider) {
        OAuth2ClientProvider provider = new OAuth2ClientProvider(this.authorizationProperties);
        provider.setTokenGenerator(tokenGenerator);
        provider.setAuthenticationCache(authenticationCache);
        for (OAuth2ClientUserResolver resolver : clientUserResolverObjectProvider) {
            Assert.hasText((String)resolver.supportClient(), () -> resolver.getClass().getName() + "\u7684supportClient\u4e3a\u7a7a");
            if (CharSequenceUtil.equals((CharSequence)resolver.supportClient(), (CharSequence)"default")) {
                provider.setDefaultUserResolver(resolver);
                continue;
            }
            provider.addOAuth2ClientUserResolver(resolver.supportClient(), resolver);
        }
        return provider;
    }

    @Bean
    @ConditionalOnBean(value={UserDetailManager.class})
    public OAuth2ClientUserResolver defaultOAuth2ClientUserResolver(UserDetailManager userDetailManager) {
        return new DefaultOAuth2CLientUserResolver(userDetailManager);
    }

    @Bean
    public OAuth2LoginSupportController oAuth2SettingController(OAuth2ClientProvider oAuth2ClientProvider) {
        return new OAuth2LoginSupportController(oAuth2ClientProvider);
    }
}

