/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet;

import com.elitescloud.cloudt.authorization.api.client.config.security.AbstractServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAccessDeniedHandler;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationFailureHandler;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.authorization.api.provider.config.LoginSupportConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.ServletOAuth2ClientConfig;
import com.elitescloud.cloudt.authorization.api.provider.provider.task.AutoClearExpiredTokenTask;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.LoginFilterSecurityConfigurer;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.OAuth2AuthorizationCodeStateFilterSecurityConfigurer;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2AccessTokenResponseHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2AuthorizationResponseHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2ServerAuthenticationEntryPointHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2ServerAuthenticationSuccessHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.OAuth2ServerErrorResponseHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.support.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.RedisOAuth2AuthorizationCodeRequestCache;
import com.elitescloud.cloudt.authorization.api.provider.service.OAuth2AuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.JPAOAuth2AuthenticationServiceImpl;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.JpaOAuth2AuthorizationConsentService;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.JpaOAuth2AuthorizationService;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.JpaRegisteredClientRepository;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthenticationRepo;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthenticationRepoProc;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthorizationConsentRepo;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthorizationConsentRepoProc;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2RegisteredClientRepo;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2RegisteredClientRepoProc;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.security.Principal;
import java.time.Duration;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"type"}, havingValue="oauth2_server")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={ServletOAuth2ClientConfig.class, ConfigOnJpa.class, LoginSupportConfig.class})
@EntityScan(value={"com.elitesland.cloudt.authorization.api.provider.model.entity"})
@EnableJpaRepositories(value={"com.elitesland.cloudt.authorization.api.provider.service.repository"})
public class ServletOAuth2ServerConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(ServletOAuth2ServerConfig.class);
    @Value(value="${spring.security.oauth2.resourceserver.jwt.issuer-uri:#{null}}")
    private String issuerUri;
    private ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers;

    @Bean(value={"authorizationServerSecurityFilterChain"})
    @Order(value=-2147483648)
    @ConditionalOnMissingBean(name={"authorizationServerSecurityFilterChain"})
    public SecurityFilterChain authorizationServerSecurityFilterChain(HttpSecurity http, ProviderSettings providerSettings, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache) throws Exception {
        DefaultAuthenticationFailureHandler authenticationFailureHandler = new DefaultAuthenticationFailureHandler();
        OAuth2ServerAuthenticationEntryPointHandler entryPointHandler = new OAuth2ServerAuthenticationEntryPointHandler(authorizationCodeRequestCache, providerSettings.getAuthorizationEndpoint());
        DefaultAccessDeniedHandler accessDeniedHandler = new DefaultAccessDeniedHandler();
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = new OAuth2AuthorizationServerConfigurer();
        RequestMatcher endpointsMatcher = authorizationServerConfigurer.getEndpointsMatcher();
        authorizationServerConfigurer.authorizationEndpoint(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)new OAuth2ServerErrorResponseHandler()).authorizationResponseHandler((AuthenticationSuccessHandler)new OAuth2AuthorizationResponseHandler())).clientAuthentication(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)authenticationFailureHandler)).tokenEndpoint(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)authenticationFailureHandler).accessTokenResponseHandler((AuthenticationSuccessHandler)new OAuth2AccessTokenResponseHandler())).oidc(configurer -> configurer.userInfoEndpoint(userInfoEndpoint -> userInfoEndpoint.userInfoMapper(this.oidcUserInfoMapper())));
        ((HttpSecurity)((OAuth2AuthorizationCodeStateFilterSecurityConfigurer)((HttpSecurity)((OAuth2AuthorizationServerConfigurer)http.requestMatcher(endpointsMatcher).authorizeRequests(req -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)req.anyRequest()).authenticated()).apply((SecurityConfigurerAdapter)authorizationServerConfigurer)).and()).apply(new OAuth2AuthorizationCodeStateFilterSecurityConfigurer())).and()).exceptionHandling(configurer -> {
            if (StringUtils.hasText((String)this.authorizationProperties.getLoginPage())) {
                configurer.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)entryPointHandler, (RequestMatcher)new RequestHeaderRequestMatcher("X-Auth-Redirect", "false")).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(this.authorizationProperties.getLoginPage()), (RequestMatcher)new AntPathRequestMatcher("/**"));
            } else {
                configurer.authenticationEntryPoint((AuthenticationEntryPoint)entryPointHandler);
            }
            configurer.accessDeniedHandler((AccessDeniedHandler)accessDeniedHandler);
        });
        http.oauth2ResourceServer(super.oauth2ResourceServer());
        if (Boolean.FALSE.equals(this.authorizationProperties.getCsrfEnabled())) {
            http.csrf().disable();
        } else {
            http.csrf().ignoringRequestMatchers(new RequestMatcher[]{endpointsMatcher});
        }
        this.corsConfiguration(http);
        return (SecurityFilterChain)http.build();
    }

    @Bean(value={"defaultSecurityFilterChain"})
    @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http, ProviderSettings providerSettings, TokenGenerator tokenGenerator, OAuth2AuthorizationCodeRequestCache auth2AuthorizationCodeRequestCache, RegisteredClientRepository clientRepository, OAuth2AuthorizationService authorizationService) throws Exception {
        OAuth2ServerAuthenticationSuccessHandler auth2ServerAuthenticationSuccessHandler = new OAuth2ServerAuthenticationSuccessHandler(providerSettings.getAuthorizationEndpoint(), this.authorizationProperties, auth2AuthorizationCodeRequestCache, clientRepository, authorizationService);
        auth2ServerAuthenticationSuccessHandler.setTokenGenerator(tokenGenerator);
        auth2ServerAuthenticationSuccessHandler.setAuthenticationCallable(this.getDelegateAuthenticationCallable());
        ((LoginFilterSecurityConfigurer)((Object)((LoginFilterSecurityConfigurer)super.defaultSecurityConfig(http).apply(new LoginFilterSecurityConfigurer<HttpSecurity>(this.loginFilterCustomizers))).successHandler(auth2ServerAuthenticationSuccessHandler))).failureHandler((AuthenticationFailureHandler)new DefaultAuthenticationFailureHandler());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisHelper.class})
    public OAuth2AuthorizationCodeRequestCache oAuth2AuthorizationCodeRequestCache(RedisHelper redisHelper) {
        return new RedisOAuth2AuthorizationCodeRequestCache(redisHelper);
    }

    @Bean
    public JWKSource<SecurityContext> jwkSource(RSAKey rsaKey) {
        return JwtUtil.generateJwkSource((RSAKey)rsaKey);
    }

    @Bean
    public ProviderSettings providerSettings() {
        Assert.hasText((String)this.issuerUri, (String)"spring.security.oauth2.resourceserver.jwt.issuer-uri\u4e0d\u53ef\u4e3a\u7a7a");
        return ProviderSettings.builder().issuer(this.issuerUri).build();
    }

    @Bean
    @ConditionalOnBean(value={OAuth2AuthenticationService.class})
    public AutoClearExpiredTokenTask autoClearExpiredTokenTask(OAuth2AuthenticationService authenticationService) {
        return new AutoClearExpiredTokenTask(authenticationService, Duration.ofHours(2L));
    }

    @Autowired
    public void setLoginFilterCustomizers(ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers) {
        this.loginFilterCustomizers = loginFilterCustomizers;
    }

    private Function<OidcUserInfoAuthenticationContext, OidcUserInfo> oidcUserInfoMapper() {
        return authenticationContext -> {
            OAuth2Authorization authorization = authenticationContext.getAuthorization();
            Object principal = ((Authentication)authorization.getAttribute(Principal.class.getName())).getPrincipal();
            if (principal instanceof GeneralUserDetails) {
                GeneralUserDetails userDetails = (GeneralUserDetails)principal;
                return OidcUserInfo.builder().subject(userDetails.getUsername()).phoneNumber(userDetails.getUser().getMobile()).email(userDetails.getUser().getEmail()).claim("yst_un", (Object)userDetails.getUsername()).claim("yst_ui", (Object)userDetails.getUserId()).claim("yst_ti", (Object)userDetails.getTenantId()).build();
            }
            return OidcUserInfo.builder().subject(authorization.getPrincipalName()).build();
        };
    }

    @ConditionalOnClass(value={JpaRepository.class})
    static class ConfigOnJpa {
        ConfigOnJpa() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RegisteredClientRepository registeredClientRepository(OAuth2RegisteredClientRepo oAuth2RegisteredClientRepo, OAuth2RegisteredClientRepoProc oAuth2RegisteredClientRepoProc) {
            return new JpaRegisteredClientRepository(oAuth2RegisteredClientRepo, oAuth2RegisteredClientRepoProc);
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationService authorizationService(RegisteredClientRepository registeredClientRepository, OAuth2AuthenticationRepo oAuth2AuthenticationRepo, OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc) {
            return new JpaOAuth2AuthorizationService(registeredClientRepository, oAuth2AuthenticationRepo, oAuth2AuthenticationRepoProc);
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationConsentService authorizationConsentService(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationConsentRepo oAuth2AuthorizationConsentRepo, OAuth2AuthorizationConsentRepoProc oAuth2AuthorizationConsentRepoProc) {
            return new JpaOAuth2AuthorizationConsentService(registeredClientRepository, oAuth2AuthorizationConsentRepo, oAuth2AuthorizationConsentRepoProc);
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthenticationService oAuth2AuthenticationService(OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc) {
            return new JPAOAuth2AuthenticationServiceImpl(oAuth2AuthenticationRepoProc);
        }
    }
}

