/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet;

import com.elitescloud.cloudt.authorization.api.client.config.security.AbstractServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationFailureHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.LoginSupportConfig;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.LoginFilterSecurityConfigurer;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.JwtAuthenticationSuccessHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"type"}, havingValue="single")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={LoginSupportConfig.class})
public class ServletSingleConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(ServletSingleConfig.class);
    private ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers;
    private TokenGenerator tokenGenerator;

    @Bean(value={"defaultSecurityFilterChain"})
    @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        JwtAuthenticationSuccessHandler successHandler = new JwtAuthenticationSuccessHandler(this.authorizationProperties, this.getDelegateAuthenticationCallable(), this.tokenGenerator);
        ((LoginFilterSecurityConfigurer)((Object)((LoginFilterSecurityConfigurer)super.defaultSecurityConfig(http).apply(new LoginFilterSecurityConfigurer<HttpSecurity>(this.loginFilterCustomizers))).successHandler((AuthenticationSuccessHandler)successHandler))).failureHandler((AuthenticationFailureHandler)new DefaultAuthenticationFailureHandler());
        return (SecurityFilterChain)http.build();
    }

    @Autowired
    public void setLoginFilterCustomizers(ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers) {
        this.loginFilterCustomizers = loginFilterCustomizers;
    }

    @Autowired
    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}

