/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.core.util.IdUtil;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.config.system.CaptchaEnum;
import com.elitescloud.cloudt.authorization.api.provider.model.vo.resp.CaptchaRespVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.wf.captcha.base.Captcha;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class CaptchaProvider {
    private static final Logger log = LogManager.getLogger(CaptchaProvider.class);
    private final RedisHelper redisHelper;

    public CaptchaProvider(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    public CaptchaRespVO generateCaptchaHu(CaptchaEnum captchaEnum, AbstractCaptcha captchaHu, Duration ttl) {
        Assert.notNull((Object)((Object)captchaEnum), (String)"\u672a\u77e5\u9a8c\u8bc1\u7801\u7c7b\u578b");
        Assert.notNull((Object)captchaHu, (String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        String uuid = IdUtil.simpleUUID();
        String key = this.buildCacheKey(captchaEnum, uuid);
        CaptchaRespVO respVO = new CaptchaRespVO();
        respVO.setUuid(uuid);
        String code = captchaHu.getCode();
        this.cacheCaptcha(key, code, ttl);
        respVO.setImg("data:image/jpg;base64," + captchaHu.getImageBase64Data());
        respVO.setCaptext(code);
        return respVO;
    }

    public CaptchaRespVO generateCaptcha(CaptchaEnum captchaEnum, Captcha captcha, Duration ttl) {
        Assert.notNull((Object)((Object)captchaEnum), (String)"\u672a\u77e5\u9a8c\u8bc1\u7801\u7c7b\u578b");
        Assert.notNull((Object)captcha, (String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        String uuid = IdUtil.simpleUUID();
        String key = this.buildCacheKey(captchaEnum, uuid);
        CaptchaRespVO respVO = new CaptchaRespVO();
        respVO.setUuid(uuid);
        String code = captcha.text();
        this.cacheCaptcha(key, code, ttl);
        respVO.setImg(captcha.toBase64());
        respVO.setCaptext(code);
        return respVO;
    }

    public boolean verifyCaptcha(CaptchaEnum captchaEnum, String uuid, String text) {
        Assert.notNull((Object)((Object)captchaEnum), (String)"\u672a\u77e5\u9a8c\u8bc1\u7801\u7c7b\u578b");
        Assert.hasText((String)uuid, (String)"\u672a\u77e5\u6821\u9a8c\u7801\u6807\u8bc6");
        Assert.hasText((String)text, (String)"\u672a\u77e5\u6821\u9a8c\u7801");
        String key = this.buildCacheKey(captchaEnum, uuid);
        String captcha = null;
        try {
            captcha = (String)this.redisHelper.execute(redisUtils -> redisUtils.get(key));
        }
        catch (Exception e) {
            throw new BusinessException("\u9a8c\u8bc1\u9a8c\u8bc1\u7801\u5931\u8d25", (Throwable)e);
        }
        if (text.equals(captcha)) {
            try {
                this.redisHelper.execute(redisUtils -> {
                    redisUtils.del(new String[]{key});
                    return null;
                });
            }
            catch (Exception e) {
                log.error("\u9a8c\u8bc1\u7801\u3010" + key + "\u3011\u6821\u9a8c\u901a\u8fc7\u540e\uff0c\u5220\u9664\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private String buildCacheKey(CaptchaEnum captchaEnum, String uuid) {
        return "yst_authorization:CAPTCHA:" + captchaEnum + ":" + uuid;
    }

    private void cacheCaptcha(String key, String value, Duration ttl) {
        try {
            this.redisHelper.execute(redisUtils -> {
                if (ttl == null) {
                    redisUtils.set(key, (Object)value);
                    return null;
                }
                redisUtils.set(key, (Object)value, ttl.getSeconds(), TimeUnit.SECONDS);
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25", (Throwable)e);
        }
    }
}

