/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.model.OAuthToken;
import com.elitescloud.cloudt.authorization.api.provider.model.bo.OAuth2ClientConfigBO;
import com.elitescloud.cloudt.authorization.api.provider.model.vo.resp.OAuth2SettingRespVO;
import com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.support.OAuth2ClientUserResolver;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.sdk.util.RestTemplateFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class OAuth2ClientProvider
implements ApplicationRunner {
    private static final Logger log = LogManager.getLogger(OAuth2ClientProvider.class);
    private static final String URI_AUTHORIZATION = "/.well-known/oauth-authorization-server";
    private static final String URI_OIDC = "/.well-known/openid-configuration";
    private final AuthorizationProperties authorizationProperties;
    private final RestTemplate restTemplate;
    private OAuth2ClientConfigBO clientConfig = null;
    private final Map<String, OAuth2ClientConfigBO> externalClientConfigMap = new HashMap<String, OAuth2ClientConfigBO>();
    private TokenGenerator tokenGenerator;
    private AuthenticationCache authenticationCache;
    private OAuth2ClientUserResolver defaultUserResolver;
    private final Map<String, OAuth2ClientUserResolver> userResolverMap = new HashMap<String, OAuth2ClientUserResolver>();
    private OAuth2SettingRespVO oAuth2SettingRespVO;

    public OAuth2ClientProvider(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
        this.restTemplate = this.buildRestTemplate();
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setAuthenticationCache(AuthenticationCache authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    public void setDefaultUserResolver(OAuth2ClientUserResolver defaultUserResolver) {
        this.defaultUserResolver = defaultUserResolver;
    }

    public void addOAuth2ClientUserResolver(String clientId, OAuth2ClientUserResolver resolver) {
        this.userResolverMap.put(clientId, resolver);
    }

    public void run(ApplicationArguments args) throws Exception {
        boolean noConfig;
        boolean bl = noConfig = (this.authorizationProperties.getOauth2Client() == null || CharSequenceUtil.isBlank((CharSequence)this.authorizationProperties.getOauth2Client().getClientId())) && CollectionUtils.isEmpty((Collection)this.authorizationProperties.getExternalOauth2Clients());
        if (noConfig) {
            return;
        }
        CompletableFuture.runAsync(this::initConfig).whenComplete((res, exp) -> {
            if (exp == null) {
                log.info("\u521d\u59cb\u5316OAuth2 Client\u914d\u7f6e\u6210\u529f\uff01");
                return;
            }
            log.error("\u521d\u59cb\u5316OAuth2 Client\u914d\u7f6e\u5931\u8d25\uff1a", exp);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OAuth2SettingRespVO getSettings() {
        if (this.oAuth2SettingRespVO != null) return this.oAuth2SettingRespVO;
        Class<OAuth2ClientProvider> clazz = OAuth2ClientProvider.class;
        synchronized (OAuth2ClientProvider.class) {
            if (this.oAuth2SettingRespVO != null) return this.oAuth2SettingRespVO;
            this.oAuth2SettingRespVO = new OAuth2SettingRespVO();
            if (this.clientConfig != null) {
                this.oAuth2SettingRespVO.setClientId(this.clientConfig.getClientId());
                this.oAuth2SettingRespVO.setAuthorizeEndpoint(this.clientConfig.getAuthorizeEndpoint());
            }
            if (this.externalClientConfigMap.isEmpty()) {
                this.oAuth2SettingRespVO.setExternalClients(Collections.emptyList());
            } else {
                List<OAuth2SettingRespVO.ExternalClient> clients = this.externalClientConfigMap.values().stream().map(t -> {
                    OAuth2SettingRespVO.ExternalClient c = new OAuth2SettingRespVO.ExternalClient();
                    c.setClientId(t.getClientId());
                    c.setClientName(t.getClientName());
                    c.setClientIcon(t.getClientIcon());
                    c.setAuthorizeEndpoint(t.getAuthorizeEndpoint());
                    return c;
                }).collect(Collectors.toList());
                this.oAuth2SettingRespVO.setExternalClients(clients);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.oAuth2SettingRespVO;
        }
    }

    public OAuth2ClientConfigBO getClientConfig(@NonNull String clientId) {
        if (this.clientConfig != null && CharSequenceUtil.equals((CharSequence)clientId, (CharSequence)this.clientConfig.getClientId())) {
            return this.clientConfig.copy();
        }
        OAuth2ClientConfigBO cfg = this.externalClientConfigMap.get(clientId);
        return cfg == null ? null : cfg.copy();
    }

    public ApiResult<OAuthToken> code2AccessToken(@NonNull String clientId, @NonNull String code, @NonNull String redirectUri, String codeVerifier) {
        boolean external = false;
        OAuth2ClientConfigBO cfg = null;
        if (this.clientConfig == null) {
            external = true;
            cfg = this.externalClientConfigMap.get(clientId);
        } else if (CharSequenceUtil.equals((CharSequence)clientId, (CharSequence)this.clientConfig.getClientId())) {
            cfg = this.clientConfig;
        }
        if (cfg == null) {
            return ApiResult.fail((String)"\u672a\u77e5OAuth2\u5ba2\u6237\u7aef");
        }
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)cfg.getClientId());
        postParam.add((Object)"client_secret", (Object)cfg.getClientSecret());
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
        postParam.add((Object)"code", (Object)code);
        postParam.add((Object)"redirect_uri", (Object)redirectUri);
        if (StringUtils.hasText((String)codeVerifier)) {
            postParam.add((Object)"code_verifier", (Object)codeVerifier);
        }
        if (external) {
            return this.exchangeTokenForExternal(cfg, (MultiValueMap<String, Object>)postParam);
        }
        try {
            ResponseEntity resp = this.restTemplate.exchange(cfg.getTokenEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<ApiResult<OAuthToken>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return (ApiResult)resp.getBody();
            }
            log.error("\u6388\u6743\u7801\u8f6ctoken\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
            return ApiResult.fail((String)"\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff01");
        }
    }

    private ApiResult<OAuthToken> exchangeTokenForExternal(OAuth2ClientConfigBO cfg, MultiValueMap<String, Object> postParam) {
        OAuth2ClientUserResolver resolver = this.userResolverMap.getOrDefault(cfg.getClientId(), this.defaultUserResolver);
        if (resolver == null) {
            return ApiResult.fail((String)"\u672a\u914d\u7f6eOAuth2\u7528\u6237\u4fe1\u606f\u89e3\u6790\u65b9\u5f0f");
        }
        GeneralUserDetails user = resolver.resolveUsername(this.restTemplate, cfg, postParam);
        if (user == null) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f");
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getUsername(), (Object)user.getPassword(), Collections.emptyList());
        OAuthToken token = this.tokenGenerator.generate((Authentication)authentication);
        this.authenticationCache.setUserDetail(token.getAccessToken(), user, this.cachePrincipalDuration());
        return ApiResult.ok((Object)token);
    }

    private Duration cachePrincipalDuration() {
        if (this.authorizationProperties.getTokenTtl() != null && this.authorizationProperties.getTokenTtl().getSeconds() > 0L) {
            return this.authorizationProperties.getTokenTtl();
        }
        return null;
    }

    private void initConfig() {
        if (this.authorizationProperties.getOauth2Client() != null && CharSequenceUtil.isNotBlank((CharSequence)this.authorizationProperties.getOauth2Client().getClientId())) {
            this.clientConfig = this.buildConfigBo(this.authorizationProperties.getOauth2Client());
        }
        if (!CollectionUtils.isEmpty((Collection)this.authorizationProperties.getExternalOauth2Clients())) {
            for (AuthorizationProperties.OAuth2Client externalOauth2Client : this.authorizationProperties.getExternalOauth2Clients()) {
                this.externalClientConfigMap.put(externalOauth2Client.getClientId(), this.buildConfigBo(externalOauth2Client));
            }
        }
    }

    private OAuth2ClientConfigBO buildConfigBo(AuthorizationProperties.OAuth2Client client) {
        Assert.hasText((String)client.getClientId(), (String)"\u5ba2\u6237\u7aefID\u4e0d\u4e3a\u7a7a");
        Assert.hasText((String)client.getClientSecret(), () -> client.getClientId() + "\u5ba2\u6237\u7aefsecret\u4e3a\u7a7a");
        Assert.hasText((String)client.getServerAddress(), () -> client.getClientId() + "\u670d\u52a1\u7aef\u5730\u5740\u4e3a\u7a7a");
        OAuth2ClientConfigBO configBO = new OAuth2ClientConfigBO();
        configBO.setClientId(client.getClientId());
        configBO.setClientSecret(client.getClientSecret());
        configBO.setClientName(client.getClientName());
        configBO.setClientIcon(client.getClientIcon());
        Map<String, Object> authorizationConfig = null;
        Map<String, Object> userInfoConfig = null;
        if (StringUtils.hasText((String)client.getUserinfoEndpoint())) {
            Assert.isTrue((boolean)client.getUserinfoEndpoint().toLowerCase().startsWith("http"), () -> client.getClientId() + " UserinfoEndpoint\u5fc5\u987b\u662f\u5168\u8def\u5f84");
            configBO.setUserinfoEndpoint(client.getUserinfoEndpoint());
            userInfoConfig = Collections.emptyMap();
        } else {
            userInfoConfig = this.queryServerConfig(client.getServerAddress() + URI_OIDC);
            String userinfoEndpoint = (String)userInfoConfig.get("userinfo_endpoint");
            Assert.hasText((String)userinfoEndpoint, (String)"OAuth2\u5ba2\u6237\u7aef\u7684userinfoEndpoint\u672a\u914d\u7f6e");
            configBO.setUserinfoEndpoint(userinfoEndpoint);
        }
        if (StringUtils.hasText((String)client.getAuthorizeEndpoint())) {
            Assert.isTrue((boolean)client.getAuthorizeEndpoint().toLowerCase().startsWith("http"), () -> client.getClientId() + " AuthorizeEndpoint\u5fc5\u987b\u662f\u5168\u8def\u5f84");
            configBO.setAuthorizeEndpoint(client.getAuthorizeEndpoint());
        } else {
            String authorizeEndpoint = (String)userInfoConfig.get("authorization_endpoint");
            if (!StringUtils.hasText((String)authorizeEndpoint)) {
                if (authorizationConfig == null) {
                    authorizationConfig = this.queryServerConfig(client.getServerAddress() + URI_AUTHORIZATION);
                }
                authorizeEndpoint = (String)authorizationConfig.get("authorization_endpoint");
            }
            Assert.hasText((String)authorizeEndpoint, () -> client.getClientId() + " AuthorizeEndpoint\u672a\u914d\u7f6e");
            configBO.setAuthorizeEndpoint(authorizeEndpoint);
        }
        if (StringUtils.hasText((String)client.getTokenEndpoint())) {
            Assert.isTrue((boolean)client.getTokenEndpoint().toLowerCase().startsWith("http"), () -> client.getClientId() + " TokenEndpoint\u5fc5\u987b\u662f\u5168\u8def\u5f84");
            configBO.setTokenEndpoint(client.getTokenEndpoint());
        } else {
            String tokenEndpoint = (String)userInfoConfig.get("token_endpoint");
            if (!StringUtils.hasText((String)tokenEndpoint)) {
                if (authorizationConfig == null) {
                    authorizationConfig = this.queryServerConfig(client.getServerAddress() + URI_AUTHORIZATION);
                }
                tokenEndpoint = (String)authorizationConfig.get("token_endpoint");
            }
            Assert.hasText((String)tokenEndpoint, (String)"OAuth2\u5ba2\u6237\u7aef\u7684tokenEndpoint\u672a\u914d\u7f6e");
            configBO.setTokenEndpoint(tokenEndpoint);
        }
        return configBO;
    }

    private RestTemplate buildRestTemplate() {
        return RestTemplateFactory.instance();
    }

    private Map<String, Object> queryServerConfig(String url) {
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                log.info("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u6210\u529f\uff1a{}", resp.getBody());
                return (Map)resp.getBody();
            }
            log.warn("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyMap();
    }
}

