/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.support.userresolver;

import com.elitescloud.cloudt.authorization.api.provider.model.bo.OAuth2ClientConfigBO;
import com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.support.userresolver.AbstractOAuth2ClientUserResolver;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class DefaultOAuth2CLientUserResolver
extends AbstractOAuth2ClientUserResolver {
    private static final Logger log = LogManager.getLogger(DefaultOAuth2CLientUserResolver.class);

    public DefaultOAuth2CLientUserResolver(UserDetailManager userDetailManager) {
        super(userDetailManager);
    }

    @Override
    public String supportClient() {
        return "default";
    }

    @Override
    public GeneralUserDetails resolveUsername(RestTemplate restTemplate, OAuth2ClientConfigBO cfg, MultiValueMap<String, Object> postParam) {
        Map<String, Object> tokenResult = null;
        try {
            tokenResult = this.queryToken(restTemplate, cfg, postParam);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u8ba4\u8bc1\u670d\u52a1\u4f7f\u7528\u6388\u6743\u7801\u6362\u53d6Token\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u8ba4\u8bc1\u670d\u52a1\u4f7f\u7528\u6388\u6743\u7801\u6362\u53d6Token\u5931\u8d25", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(tokenResult)) {
            log.info("\u8bf7\u6c42\u8ba4\u8bc1\u670d\u52a1\u4f7f\u7528\u6388\u6743\u7801\u6362\u53d6Token\u4e0d\u6210\u529f\uff0c\u8bf7\u6c42\u7ed3\u679c\u672a\u80fd\u89e3\u6790\u6210\u529f\uff01");
            return null;
        }
        String username = this.obtainUsernameByToken(tokenResult);
        if (StringUtils.hasText((String)username)) {
            return this.userDetailManager.loadUserByUsername(username);
        }
        return null;
    }
}

