/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.handler;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.io.IOException;
import java.time.Duration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;

public class CacheUserAuthenticationCallable
implements AuthenticationCallable {
    private static final Logger log = LogManager.getLogger(CacheUserAuthenticationCallable.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthenticationCache authenticationCache;

    public CacheUserAuthenticationCallable(AuthorizationProperties authorizationProperties, AuthenticationCache authenticationCache) {
        this.authorizationProperties = authorizationProperties;
        this.authenticationCache = authenticationCache;
    }

    public void onLogin(HttpServletRequest request, HttpServletResponse response, String token, Authentication authentication) throws IOException, ServletException {
        GeneralUserDetails user = null;
        if (authentication.getPrincipal() instanceof GeneralUserDetails) {
            user = (GeneralUserDetails)authentication.getPrincipal();
        }
        if (user != null && token != null) {
            log.info("\u7528\u6237{}\u767b\u5f55\uff0ctoken\uff1a{}", (Object)user.getUsername(), (Object)token);
            this.authenticationCache.setUserDetail(token, user, this.cachePrincipalDuration());
        }
    }

    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        if (!StringUtils.hasText((String)token)) {
            return;
        }
        this.authenticationCache.removeUserDetail(token);
    }

    private Duration cachePrincipalDuration() {
        if (this.authorizationProperties.getTokenTtl() != null && this.authorizationProperties.getTokenTtl().getSeconds() > 0L) {
            return this.authorizationProperties.getTokenTtl();
        }
        return null;
    }
}

