/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server;

import com.elitescloud.cloudt.authorization.api.client.model.OAuthToken;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.AbstractOAuth2ServerHandler;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2AccessTokenResponseHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationSuccessHandler {
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        OAuth2AccessTokenAuthenticationToken accessTokenAuthentication = (OAuth2AccessTokenAuthenticationToken)authentication;
        OAuth2AccessToken accessToken = accessTokenAuthentication.getAccessToken();
        OAuth2RefreshToken refreshToken = accessTokenAuthentication.getRefreshToken();
        Map additionalParameters = accessTokenAuthentication.getAdditionalParameters();
        OAuth2AccessTokenResponse.Builder builder = OAuth2AccessTokenResponse.withToken((String)accessToken.getTokenValue()).tokenType(accessToken.getTokenType()).scopes(accessToken.getScopes());
        if (accessToken.getIssuedAt() != null && accessToken.getExpiresAt() != null) {
            builder.expiresIn(ChronoUnit.SECONDS.between(accessToken.getIssuedAt(), accessToken.getExpiresAt()));
        }
        if (refreshToken != null) {
            builder.refreshToken(refreshToken.getTokenValue());
        }
        if (!CollectionUtils.isEmpty((Map)additionalParameters)) {
            builder.additionalParameters(additionalParameters);
        }
        OAuth2AccessTokenResponse accessTokenResponse = builder.build();
        OAuthToken oauthToken = OAuth2AccessTokenResponseHandler.convertOAuth2AccessToken(accessTokenResponse);
        this.writeResponse(response, ApiResult.ok((Object)oauthToken));
    }

    private static OAuthToken convertOAuth2AccessToken(OAuth2AccessTokenResponse tokenResponse) {
        String idToken;
        OAuthToken token = new OAuthToken();
        token.setAccessToken(tokenResponse.getAccessToken().getTokenValue());
        token.setTokenType(tokenResponse.getAccessToken().getTokenType().getValue());
        token.setExpiresIn(Long.valueOf(OAuth2AccessTokenResponseHandler.getExpiresIn(tokenResponse)));
        token.setScope(Objects.requireNonNullElse(tokenResponse.getAccessToken().getScopes(), Collections.emptySet()));
        OAuth2RefreshToken refreshToken = tokenResponse.getRefreshToken();
        if (refreshToken != null) {
            token.setRefreshToken(refreshToken.getTokenValue());
        }
        if (StringUtils.hasText((String)(idToken = (String)tokenResponse.getAdditionalParameters().get("id_token")))) {
            token.setIdToken(idToken);
        }
        return token;
    }

    private static long getExpiresIn(OAuth2AccessTokenResponse tokenResponse) {
        if (tokenResponse.getAccessToken().getExpiresAt() != null) {
            return ChronoUnit.SECONDS.between(Instant.now(), tokenResponse.getAccessToken().getExpiresAt());
        }
        return -1L;
    }
}

