/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.model.OAuthToken;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.AbstractOAuth2ServerHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.support.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2ServerAuthenticationSuccessHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationSuccessHandler {
    private static final Logger log = LogManager.getLogger(OAuth2ServerAuthenticationSuccessHandler.class);
    private final RequestCache requestCache = new HttpSessionRequestCache();
    private final String authorizationEndpoint;
    private final AuthorizationProperties authorizationProperties;
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private final RegisteredClientRepository clientRepository;
    private final OAuth2AuthorizationService oAuth2AuthorizationService;
    private TokenGenerator tokenGenerator;
    private DelegateAuthenticationCallable authenticationCallable;

    public OAuth2ServerAuthenticationSuccessHandler(String authorizationEndpoint, AuthorizationProperties authorizationProperties, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache, RegisteredClientRepository clientRepository, OAuth2AuthorizationService oAuth2AuthorizationService) {
        this.authorizationEndpoint = authorizationEndpoint;
        this.authorizationProperties = authorizationProperties;
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
        this.clientRepository = clientRepository;
        this.oAuth2AuthorizationService = oAuth2AuthorizationService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (this.attemptToHandleOAuth2Response(request, response, authentication, savedRequest)) {
            return;
        }
        OAuthToken authToken = this.generateToken(authentication);
        this.authenticationCallable.onLogin(request, response, authToken == null ? null : authToken.getAccessToken(), authentication);
        this.writeResponse(response, ApiResult.ok((Object)authToken));
    }

    private OAuthToken generateToken(Authentication authentication) {
        if (this.tokenGenerator == null) {
            return null;
        }
        return this.tokenGenerator.generate(authentication);
    }

    private boolean attemptToHandleOAuth2Response(HttpServletRequest request, HttpServletResponse response, Authentication authentication, SavedRequest savedRequest) throws IOException {
        String redirectUri;
        String state;
        if (savedRequest != null) {
            if (!CharSequenceUtil.equals((CharSequence)this.obtainServletPath(savedRequest), (CharSequence)this.authorizationEndpoint)) {
                return false;
            }
            if (this.supportRedirect(savedRequest)) {
                this.sendRedirect(this.authorizationProperties.getRedirectUriPrefix(), (DefaultSavedRequest)savedRequest, request, response);
                return true;
            }
        }
        if (!StringUtils.hasText((String)(state = request.getParameter("state")))) {
            log.debug("\u7f3a\u5c11state\u53c2\u6570\uff0c\u65e0\u6cd5\u786e\u5b9a\u4e3aOAuth2\u8bf7\u6c42");
            return false;
        }
        OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = this.authorizationCodeRequestCache.getAuthenticationToken(state);
        if (codeRequest == null) {
            log.error("\u672a\u627e\u5230\u6388\u6743\u7801\u8ba4\u8bc1\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)state);
            this.writeResponse(response, ApiResult.fail((String)"\u8ba4\u8bc1\u4fe1\u606f\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u8ba4\u8bc1"));
            return true;
        }
        RegisteredClient client = this.clientRepository.findByClientId(codeRequest.getClientId());
        if (client == null) {
            this.writeResponse(response, ApiResult.fail((String)"\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528"));
            return true;
        }
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri(codeRequest.getAuthorizationUri()).clientId(codeRequest.getClientId()).redirectUri(codeRequest.getRedirectUri()).scopes(codeRequest.getScopes()).state(codeRequest.getState()).additionalParameters(codeRequest.getAdditionalParameters()).build();
        OAuth2Authorization authorization = OAuth2ServerAuthenticationSuccessHandler.authorizationBuilder(client, authentication, authorizationRequest).attribute("state", (Object)codeRequest.getState()).attribute("client_id", (Object)codeRequest.getClientId()).build();
        this.oAuth2AuthorizationService.save(authorization);
        this.authorizationCodeRequestCache.removeAuthenticationToken(state);
        String string = redirectUri = CollectionUtils.isEmpty((Collection)client.getRedirectUris()) ? null : (String)client.getRedirectUris().stream().filter(CharSequenceUtil::isNotBlank).findFirst().orElse(null);
        if (StringUtils.hasText(redirectUri)) {
            this.sendRedirect(request, response, redirectUri);
            return true;
        }
        this.writeResponse(response, ApiResult.ok((Object)"\u8ba4\u8bc1\u6210\u529f"));
        return true;
    }

    private String obtainServletPath(SavedRequest savedRequest) {
        if (savedRequest instanceof DefaultSavedRequest) {
            return ((DefaultSavedRequest)savedRequest).getServletPath();
        }
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684SavedRequest\u7c7b\u578b");
    }

    private static OAuth2Authorization.Builder authorizationBuilder(RegisteredClient registeredClient, Authentication principal, OAuth2AuthorizationRequest authorizationRequest) {
        return OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient).principalName(principal.getName()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).attribute(Principal.class.getName(), (Object)principal).attribute(OAuth2AuthorizationRequest.class.getName(), (Object)authorizationRequest);
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setAuthenticationCallable(DelegateAuthenticationCallable authenticationCallable) {
        this.authenticationCallable = authenticationCallable;
    }
}

