/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.handler.sso;

import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.ticket.TicketGenerator;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.TicketResolver;
import com.elitescloud.cloudt.authorization.sdk.util.AuthorizationServerHelper;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SsoTicketAuthenticationCallable
implements AuthenticationCallable {
    private static final Logger log = LogManager.getLogger(SsoTicketAuthenticationCallable.class);
    private final AuthorizationSdkProperties sdkProperties;
    private final TicketGenerator ticketGenerator;
    private final TicketResolver ticketResolver;
    private final AuthorizationServerHelper authorizationServerHelper = AuthorizationServerHelper.getInstance();

    public SsoTicketAuthenticationCallable(AuthorizationSdkProperties sdkProperties, TicketGenerator ticketGenerator, TicketResolver ticketResolver) {
        this.sdkProperties = sdkProperties;
        this.ticketGenerator = ticketGenerator;
        this.ticketResolver = ticketResolver;
    }

    public void onLogin(HttpServletRequest request, HttpServletResponse response, String token, Authentication authentication) throws IOException, ServletException {
        if (authentication.getPrincipal() instanceof GeneralUserDetails) {
            this.writeTicket(request, response, (GeneralUserDetails)authentication.getPrincipal());
        }
    }

    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        String ticket = this.ticketResolver.obtain(request);
        if (!StringUtils.hasText((String)ticket)) {
            log.info("\u6ca1\u6709\u5355\u70b9\u767b\u5f55ticket");
            return;
        }
        this.ticketResolver.clear(request, response);
        CompletableFuture.runAsync(() -> {
            try {
                this.ticketGenerator.remove(ticket);
            }
            catch (Exception e) {
                log.error("ticket\u5220\u9664\u5f02\u5e38", (Throwable)e);
            }
            if (CollectionUtils.isEmpty((Collection)this.sdkProperties.getSso().getClientAddress())) {
                log.warn("\u672a\u914d\u7f6e\u5355\u70b9\u767b\u5f55\u5ba2\u6237\u7aef\uff0c\u65e0\u6cd5\u6ce8\u9500\u5ba2\u6237\u7aef");
                return;
            }
            for (String clientAddress : this.sdkProperties.getSso().getClientAddress()) {
                try {
                    this.authorizationServerHelper.clientLogout(clientAddress, this.sdkProperties.getSso().getAuthorizeRevokeEndpoint(), ticket);
                }
                catch (Exception e) {
                    log.error("SSO\u8c03\u7528\u5ba2\u6237\u7aef\u6ce8\u9500\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        });
    }

    private void writeTicket(HttpServletRequest request, HttpServletResponse response, GeneralUserDetails user) {
        Set domains = this.sdkProperties.getSso().getCookieDomains();
        if (CollectionUtils.isEmpty((Collection)domains)) {
            log.warn("\u672a\u914d\u7f6e\u57df\u540d\uff0c\u65e0\u9700\u751f\u6210\u5355\u70b9\u767b\u5f55ticket\u5199\u5165cookie");
            return;
        }
        String ticket = null;
        if (this.sdkProperties.getServer().booleanValue()) {
            ticket = this.ticketGenerator.generate(user.getUser());
        } else {
            String account = this.getAccount(user);
            Assert.hasText((String)account, (String)"\u8d26\u53f7\u4e3a\u7a7a");
            ticket = this.authorizationServerHelper.generateTicket(this.sdkProperties.getAuthServer(), account, this.sdkProperties.getSso().getAccountType().name());
        }
        if (!StringUtils.hasText((String)ticket)) {
            log.info("\u672a\u751f\u6210ticket\uff0c\u7528\u6237\uff1a{}", (Object)user.getUsername());
            return;
        }
        log.info("\u7528\u6237{}\u767b\u5f55\uff0cticket\uff1a{},\u5c06\u5199\u5165cookie", (Object)user.getUsername(), (Object)ticket);
        this.ticketResolver.save(request, response, ticket);
    }

    private String getAccount(GeneralUserDetails userDetails) {
        SysUserDTO user = userDetails.getUser();
        switch (this.sdkProperties.getSso().getAccountType()) {
            case USER_ID: {
                return user.getId().toString();
            }
            case USER_NAME: {
                return user.getUsername();
            }
            case EMAIL: {
                return user.getEmail();
            }
            case MOBILE: {
                return user.getMobile();
            }
        }
        return user.getUsername();
    }
}

