/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.impl;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.oauth2.server.support.OAuth2AuthorizationCodeRequestCache;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;

public class RedisOAuth2AuthorizationCodeRequestCache
implements OAuth2AuthorizationCodeRequestCache {
    private static final Logger log = LogManager.getLogger(RedisOAuth2AuthorizationCodeRequestCache.class);
    private final RedisHelper redisHelper;

    public RedisOAuth2AuthorizationCodeRequestCache(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    @Override
    public void setAuthenticationToken(String state, OAuth2AuthorizationCodeRequestAuthenticationToken authenticationToken, Duration timeToLive) {
        try {
            this.redisHelper.execute(redisUtils -> {
                if (timeToLive == null) {
                    redisUtils.set(state, (Object)authenticationToken);
                    return null;
                }
                redisUtils.set(state, (Object)authenticationToken, timeToLive.toSeconds(), TimeUnit.SECONDS);
                return null;
            });
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u6388\u6743\u7801\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            throw new AuthorizationException("\u6388\u6743\u7801\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public OAuth2AuthorizationCodeRequestAuthenticationToken getAuthenticationToken(String state) {
        try {
            return (OAuth2AuthorizationCodeRequestAuthenticationToken)this.redisHelper.execute(redisUtils -> redisUtils.get(state));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f13\u5b58\u6388\u6743\u7801\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            throw new AuthorizationException("\u6388\u6743\u7801\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void removeAuthenticationToken(String state) {
        try {
            this.redisHelper.execute(redisUtils -> {
                redisUtils.del(new String[]{state});
                return null;
            });
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7f13\u5b58\u6388\u6743\u7801\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }
}

