/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.service.impl;

import com.elitescloud.cloudt.authorization.api.provider.security.util.AuthenticationTool;
import com.elitescloud.cloudt.context.util.DatetimeUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public abstract class BaseCustomAuthorizationService {
    private static final Logger log = LogManager.getLogger(BaseCustomAuthorizationService.class);
    private ObjectMapper objectMapper;

    protected String toJsonString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("\u8f6cjson\u5b57\u7b26\u4e32\u51fa\u9519\uff1a", (Throwable)e);
            return null;
        }
    }

    protected <T> T toJsonObj(String jsonString, TypeReference<T> typeReference) {
        if (!StringUtils.hasText((String)jsonString)) {
            return null;
        }
        try {
            return (T)this.getObjectMapper().readValue(jsonString, typeReference);
        }
        catch (JsonProcessingException e) {
            log.error("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u51fa\u9519\uff1a", (Throwable)e);
            return null;
        }
    }

    protected LocalDateTime toLocalDateTime(Instant instant) {
        if (instant == null) {
            return null;
        }
        return instant.atZone(DatetimeUtil.SYS_ZONE_OFFSET).toLocalDateTime();
    }

    protected Instant toInstant(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.toInstant(DatetimeUtil.SYS_ZONE_OFFSET);
    }

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        this.objectMapper = AuthenticationTool.buildObjectMapperForSecurity();
        return this.objectMapper;
    }
}

