/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.service.impl;

import com.elitescloud.cloudt.authorization.api.provider.service.OAuth2AuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.BaseCustomAuthorizationService;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthenticationRepoProc;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class JPAOAuth2AuthenticationServiceImpl
extends BaseCustomAuthorizationService
implements OAuth2AuthenticationService {
    private static final Logger log = LogManager.getLogger(JPAOAuth2AuthenticationServiceImpl.class);
    private final OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc;

    public JPAOAuth2AuthenticationServiceImpl(OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc) {
        this.oAuth2AuthenticationRepoProc = oAuth2AuthenticationRepoProc;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteAllExpiredToken() {
        LocalDateTime expiredTime = LocalDateTime.now();
        this.oAuth2AuthenticationRepoProc.deleteByRefreshTokenExpiresAt(expiredTime);
        this.oAuth2AuthenticationRepoProc.deleteByAuthorizationCodeExpiresAt(expiredTime);
    }
}

