/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.authorization.api.provider.model.entity.OAuth2AuthorizationDO;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.BaseCustomAuthorizationService;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthenticationRepo;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthenticationRepoProc;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class JpaOAuth2AuthorizationService
extends BaseCustomAuthorizationService
implements OAuth2AuthorizationService {
    private static final Logger log = LogManager.getLogger(JpaOAuth2AuthorizationService.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthenticationRepo oAuth2AuthenticationRepo;
    private final OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc;

    public JpaOAuth2AuthorizationService(RegisteredClientRepository registeredClientRepository, OAuth2AuthenticationRepo oAuth2AuthenticationRepo, OAuth2AuthenticationRepoProc oAuth2AuthenticationRepoProc) {
        this.registeredClientRepository = registeredClientRepository;
        this.oAuth2AuthenticationRepo = oAuth2AuthenticationRepo;
        this.oAuth2AuthenticationRepoProc = oAuth2AuthenticationRepoProc;
    }

    public void save(OAuth2Authorization authorization) {
        if (authorization == null) {
            log.error("authorization\u4e3a\u7a7a");
            return;
        }
        OAuth2AuthorizationDO auth2AuthorizationDO = this.toDo(authorization);
        this.oAuth2AuthenticationRepo.save(auth2AuthorizationDO);
    }

    public void remove(OAuth2Authorization authorization) {
        if (authorization == null || !StringUtils.hasText((String)authorization.getId())) {
            log.error("\u5220\u9664authorization\u5931\u8d25");
            return;
        }
        this.oAuth2AuthenticationRepoProc.delete(authorization.getId());
    }

    public OAuth2Authorization findById(String id) {
        if (!StringUtils.hasText((String)id)) {
            log.error("\u67e5\u8be2authorization\u5931\u8d25\uff0cID\u4e3a\u7a7a");
            return null;
        }
        OAuth2AuthorizationDO authorizationDO = this.oAuth2AuthenticationRepo.findById(id).orElse(null);
        return this.toBo(authorizationDO);
    }

    public OAuth2Authorization findByToken(String token, OAuth2TokenType tokenType) {
        Assert.hasText((String)token, (String)"token\u4e3a\u7a7a");
        OAuth2AuthorizationDO authorizationDO = this.oAuth2AuthenticationRepoProc.getByToken(token, tokenType);
        return this.toBo(authorizationDO);
    }

    private OAuth2AuthorizationDO toDo(OAuth2Authorization authorization) {
        OAuth2Authorization.Token refreshToken;
        OAuth2Authorization.Token oidcIdToken;
        OAuth2Authorization.Token accessToken;
        OAuth2AuthorizationDO authorizationDO = new OAuth2AuthorizationDO();
        authorizationDO.setId(CharSequenceUtil.blankToDefault((CharSequence)authorization.getId(), (String)IdUtil.fastSimpleUUID()));
        authorizationDO.setRegisteredClientId(authorization.getRegisteredClientId());
        authorizationDO.setPrincipalName(authorization.getPrincipalName());
        if (authorization.getAuthorizationGrantType() != null) {
            authorizationDO.setAuthorizationGrantType(authorization.getAuthorizationGrantType().getValue());
        }
        authorizationDO.setAttributes(this.toJsonString(authorization.getAttributes()));
        authorizationDO.setState((String)authorization.getAttribute("state"));
        OAuth2Authorization.Token authorizationCode = authorization.getToken(OAuth2AuthorizationCode.class);
        if (authorizationCode != null) {
            OAuth2AuthorizationCode token = (OAuth2AuthorizationCode)authorizationCode.getToken();
            if (token != null) {
                authorizationDO.setAuthorizationCodeValue(token.getTokenValue());
                authorizationDO.setAuthorizationCodeIssuedAt(this.toLocalDateTime(token.getIssuedAt()));
                authorizationDO.setAuthorizationCodeExpiresAt(this.toLocalDateTime(token.getExpiresAt()));
            }
            authorizationDO.setAuthorizationCodeMetadata(this.toJsonString(authorizationCode.getMetadata()));
        }
        if ((accessToken = authorization.getToken(OAuth2AccessToken.class)) != null) {
            OAuth2AccessToken token = (OAuth2AccessToken)accessToken.getToken();
            if (token != null) {
                authorizationDO.setAccessTokenValue(token.getTokenValue());
                authorizationDO.setAccessTokenIssuedAt(this.toLocalDateTime(token.getIssuedAt()));
                authorizationDO.setAccessTokenExpiresAt(this.toLocalDateTime(token.getExpiresAt()));
                if (token.getTokenType() != null) {
                    authorizationDO.setAccessTokenType(token.getTokenType().getValue());
                }
                authorizationDO.setAccessTokenScopes(this.toJsonString(token.getScopes()));
            }
            authorizationDO.setAccessTokenMetadata(this.toJsonString(accessToken.getMetadata()));
        }
        if ((oidcIdToken = authorization.getToken(OidcIdToken.class)) != null) {
            OidcIdToken token = (OidcIdToken)oidcIdToken.getToken();
            if (token != null) {
                authorizationDO.setOidcIdTokenValue(token.getTokenValue());
                authorizationDO.setOidcIdTokenIssuedAt(this.toLocalDateTime(token.getIssuedAt()));
                authorizationDO.setOidcIdTokenExpiresAt(this.toLocalDateTime(token.getExpiresAt()));
            }
            authorizationDO.setOidcIdTokenMetadata(this.toJsonString(oidcIdToken.getMetadata()));
        }
        if ((refreshToken = authorization.getRefreshToken()) != null) {
            OAuth2RefreshToken token = (OAuth2RefreshToken)refreshToken.getToken();
            if (token != null) {
                authorizationDO.setRefreshTokenValue(token.getTokenValue());
                authorizationDO.setRefreshTokenIssuedAt(this.toLocalDateTime(token.getIssuedAt()));
                authorizationDO.setRefreshTokenExpiresAt(this.toLocalDateTime(token.getExpiresAt()));
            }
            authorizationDO.setRefreshTokenMetadata(this.toJsonString(refreshToken.getMetadata()));
        }
        return authorizationDO;
    }

    public OAuth2Authorization toBo(OAuth2AuthorizationDO authorizationDO) {
        Map<String, Object> attributes;
        if (authorizationDO == null) {
            return null;
        }
        String clientId = authorizationDO.getRegisteredClientId();
        Assert.hasText((String)clientId, (String)"\u672a\u77e5token\u7684clientId");
        RegisteredClient client = this.registeredClientRepository.findById(clientId);
        Assert.notNull((Object)client, (String)"\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728");
        OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient((RegisteredClient)client);
        builder.id(authorizationDO.getId());
        builder.principalName(authorizationDO.getPrincipalName());
        if (StringUtils.hasText((String)authorizationDO.getAuthorizationGrantType())) {
            builder.authorizationGrantType(new AuthorizationGrantType(authorizationDO.getAuthorizationGrantType()));
        }
        if (!CollectionUtils.isEmpty(attributes = this.toJsonObj(authorizationDO.getAttributes(), new TypeReference<Map<String, Object>>(){}))) {
            builder.attributes(t -> t.putAll(attributes));
            if (StringUtils.hasText((String)authorizationDO.getState())) {
                builder.attribute("state", (Object)authorizationDO.getState());
            }
        }
        if (ArrayUtil.isNotEmpty((Object)authorizationDO.getAuthorizationCodeValue())) {
            String authorizationCodeValue = authorizationDO.getAuthorizationCodeValue();
            Map<String, Object> authorizationCodeMetadata = this.toJsonObj(authorizationDO.getAuthorizationCodeMetadata(), new TypeReference<Map<String, Object>>(){});
            OAuth2AuthorizationCode authorizationCode = new OAuth2AuthorizationCode(authorizationCodeValue, this.toInstant(authorizationDO.getAuthorizationCodeIssuedAt()), this.toInstant(authorizationDO.getAuthorizationCodeExpiresAt()));
            builder.token((OAuth2Token)authorizationCode, metadata -> metadata.putAll((Map)ObjectUtil.defaultIfNull((Object)authorizationCodeMetadata, Collections.emptyMap())));
        }
        if (ArrayUtil.isNotEmpty((Object)authorizationDO.getAccessTokenValue())) {
            String accessTokenValue = authorizationDO.getAccessTokenValue();
            Map<String, Object> accessTokenMetadata = this.toJsonObj(authorizationDO.getAccessTokenMetadata(), new TypeReference<Map<String, Object>>(){});
            OAuth2AccessToken.TokenType tokenType = null;
            if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(authorizationDO.getAccessTokenType())) {
                tokenType = OAuth2AccessToken.TokenType.BEARER;
            }
            Set<String> scopes = this.toJsonObj(authorizationDO.getAccessTokenScopes(), new TypeReference<Set<String>>(){});
            OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType, accessTokenValue, this.toInstant(authorizationDO.getAccessTokenIssuedAt()), this.toInstant(authorizationDO.getAccessTokenExpiresAt()), scopes);
            builder.token((OAuth2Token)accessToken, metadata -> metadata.putAll((Map)ObjectUtil.defaultIfNull((Object)accessTokenMetadata, Collections.emptyMap())));
        }
        if (ArrayUtil.isNotEmpty((Object)authorizationDO.getOidcIdTokenValue())) {
            String oidcIdTokenValue = authorizationDO.getOidcIdTokenValue();
            Map<String, Object> oidcTokenMetadata = this.toJsonObj(authorizationDO.getOidcIdTokenMetadata(), new TypeReference<Map<String, Object>>(){});
            Map tokenMetadata = oidcTokenMetadata == null ? null : (Map)oidcTokenMetadata.get(OAuth2Authorization.Token.CLAIMS_METADATA_NAME);
            OidcIdToken oidcToken = new OidcIdToken(oidcIdTokenValue, this.toInstant(authorizationDO.getOidcIdTokenIssuedAt()), this.toInstant(authorizationDO.getOidcIdTokenExpiresAt()), tokenMetadata);
            builder.token((OAuth2Token)oidcToken, t -> t.putAll((Map)ObjectUtil.defaultIfNull((Object)oidcTokenMetadata, Collections.emptyMap())));
        }
        if (ArrayUtil.isNotEmpty((Object)authorizationDO.getRefreshTokenValue())) {
            String refreshTokenValue = authorizationDO.getRefreshTokenValue();
            Map<String, Object> refreshTokenMetadata = this.toJsonObj(authorizationDO.getRefreshTokenMetadata(), new TypeReference<Map<String, Object>>(){});
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(refreshTokenValue, this.toInstant(authorizationDO.getRefreshTokenIssuedAt()), this.toInstant(authorizationDO.getRefreshTokenExpiresAt()));
            builder.token((OAuth2Token)refreshToken, metadata -> metadata.putAll((Map)ObjectUtil.defaultIfNull((Object)refreshTokenMetadata, Collections.emptyMap())));
        }
        return builder.build();
    }
}

