/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.system;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import com.elitescloud.cloudt.authorization.api.provider.config.system.CaptchaInfo;
import com.elitescloud.cloudt.authorization.api.provider.config.system.captcha.CaptchaCodeEnum;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.io.Serializable;
import java.util.Objects;

public class LoginProperties
implements Serializable {
    private static final long serialVersionUID = 3572914221247822407L;
    private CaptchaInfo captchaInfo;
    private Boolean loginLogEnabled = true;
    private Boolean terminalEnabled = true;
    private Boolean requiredSupportEmployee = true;

    public LoginProperties() {
        this.getCaptcha();
    }

    public AbstractCaptcha getCaptchaHu() {
        if (Objects.isNull(this.captchaInfo)) {
            return null;
        }
        if (this.captchaInfo.getCodeType() == CaptchaCodeEnum.line || this.captchaInfo.getCodeType() == CaptchaCodeEnum.circle || this.captchaInfo.getCodeType() == CaptchaCodeEnum.shear) {
            switch (this.captchaInfo.getCodeType()) {
                case line: {
                    return CaptchaUtil.createLineCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                }
                case circle: {
                    return CaptchaUtil.createCircleCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                }
            }
            return CaptchaUtil.createShearCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
        }
        return null;
    }

    public Captcha getCaptcha() {
        if (Objects.isNull(this.captchaInfo)) {
            this.captchaInfo = new CaptchaInfo();
            if (Objects.isNull((Object)this.captchaInfo.getCodeType())) {
                this.captchaInfo.setCodeType(CaptchaCodeEnum.arithmetic);
            }
        }
        return this.switchCaptcha(this.captchaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Captcha switchCaptcha(CaptchaInfo captchaInfo) {
        ArithmeticCaptcha captcha;
        LoginProperties loginProperties = this;
        synchronized (loginProperties) {
            switch (captchaInfo.getCodeType()) {
                case arithmetic: {
                    captcha = new ArithmeticCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese: {
                    captcha = new ChineseCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese_gif: {
                    captcha = new ChineseGifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case gif: {
                    captcha = new GifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case spec: {
                    captcha = new SpecCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                default: {
                    throw new RuntimeException("\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01\uff01\uff01\u6b63\u786e\u914d\u7f6e\u67e5\u770b com.elitesland.yst.common.property.CaptchaCodeEnum ");
                }
            }
        }
        return captcha;
    }

    public CaptchaInfo getCaptchaInfo() {
        return this.captchaInfo;
    }

    public Boolean getLoginLogEnabled() {
        return this.loginLogEnabled;
    }

    public Boolean getTerminalEnabled() {
        return this.terminalEnabled;
    }

    public Boolean getRequiredSupportEmployee() {
        return this.requiredSupportEmployee;
    }

    public void setCaptchaInfo(CaptchaInfo captchaInfo) {
        this.captchaInfo = captchaInfo;
    }

    public void setLoginLogEnabled(Boolean loginLogEnabled) {
        this.loginLogEnabled = loginLogEnabled;
    }

    public void setTerminalEnabled(Boolean terminalEnabled) {
        this.terminalEnabled = terminalEnabled;
    }

    public void setRequiredSupportEmployee(Boolean requiredSupportEmployee) {
        this.requiredSupportEmployee = requiredSupportEmployee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginProperties)) {
            return false;
        }
        LoginProperties other = (LoginProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$loginLogEnabled = this.getLoginLogEnabled();
        Boolean other$loginLogEnabled = other.getLoginLogEnabled();
        if (this$loginLogEnabled == null ? other$loginLogEnabled != null : !((Object)this$loginLogEnabled).equals(other$loginLogEnabled)) {
            return false;
        }
        Boolean this$terminalEnabled = this.getTerminalEnabled();
        Boolean other$terminalEnabled = other.getTerminalEnabled();
        if (this$terminalEnabled == null ? other$terminalEnabled != null : !((Object)this$terminalEnabled).equals(other$terminalEnabled)) {
            return false;
        }
        Boolean this$requiredSupportEmployee = this.getRequiredSupportEmployee();
        Boolean other$requiredSupportEmployee = other.getRequiredSupportEmployee();
        if (this$requiredSupportEmployee == null ? other$requiredSupportEmployee != null : !((Object)this$requiredSupportEmployee).equals(other$requiredSupportEmployee)) {
            return false;
        }
        CaptchaInfo this$captchaInfo = this.getCaptchaInfo();
        CaptchaInfo other$captchaInfo = other.getCaptchaInfo();
        return !(this$captchaInfo == null ? other$captchaInfo != null : !((Object)this$captchaInfo).equals(other$captchaInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $loginLogEnabled = this.getLoginLogEnabled();
        result = result * 59 + ($loginLogEnabled == null ? 43 : ((Object)$loginLogEnabled).hashCode());
        Boolean $terminalEnabled = this.getTerminalEnabled();
        result = result * 59 + ($terminalEnabled == null ? 43 : ((Object)$terminalEnabled).hashCode());
        Boolean $requiredSupportEmployee = this.getRequiredSupportEmployee();
        result = result * 59 + ($requiredSupportEmployee == null ? 43 : ((Object)$requiredSupportEmployee).hashCode());
        CaptchaInfo $captchaInfo = this.getCaptchaInfo();
        result = result * 59 + ($captchaInfo == null ? 43 : ((Object)$captchaInfo).hashCode());
        return result;
    }

    public String toString() {
        return "LoginProperties(captchaInfo=" + this.getCaptchaInfo() + ", loginLogEnabled=" + this.getLoginLogEnabled() + ", terminalEnabled=" + this.getTerminalEnabled() + ", requiredSupportEmployee=" + this.getRequiredSupportEmployee() + ")";
    }
}

