/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.support.userresolver;

import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.authorization.api.provider.model.bo.OAuth2ClientConfigBO;
import com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.support.OAuth2ClientUserResolver;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.common.exception.BusinessException;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractOAuth2ClientUserResolver
implements OAuth2ClientUserResolver {
    private static final Logger log = LogManager.getLogger(AbstractOAuth2ClientUserResolver.class);
    protected final UserDetailManager userDetailManager;

    protected AbstractOAuth2ClientUserResolver(UserDetailManager userDetailManager) {
        this.userDetailManager = userDetailManager;
    }

    protected Map<String, Object> decodeJwt(String tokenValue) {
        return JwtUtil.decode((String)tokenValue);
    }

    protected String obtainUsernameByToken(Map<String, Object> tokenResult) {
        String tokenValue = (String)tokenResult.get("access_token");
        try {
            Map<String, Object> payload = this.decodeJwt(tokenValue);
            return (String)payload.get("sub");
        }
        catch (Exception e) {
            log.error("token\u5185\u5bb9\uff1a{}", (Object)tokenValue);
            throw new BusinessException("\u89e3\u6790token\u5931\u8d25", (Throwable)e);
        }
    }

    protected Map<String, Object> queryToken(RestTemplate restTemplate, OAuth2ClientConfigBO cfg, MultiValueMap<String, Object> postParam) {
        ResponseEntity resp = restTemplate.exchange(cfg.getTokenEndpoint(), HttpMethod.POST, new HttpEntity(postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (!resp.getStatusCode().is2xxSuccessful() || resp.getBody() == null) {
            log.error("\u6388\u6743\u7801\u8f6ctoken\u5931\u8d25\uff1a{}\uff0c{}", (Object)resp.getStatusCode(), resp.getBody());
            return Collections.emptyMap();
        }
        Map result = (Map)resp.getBody();
        if (result.containsKey("access_token")) {
            return result;
        }
        for (Map.Entry entry : result.entrySet()) {
            if (!this.isAccessTokenBody(entry.getValue())) continue;
            return (Map)entry.getValue();
        }
        log.info("\u8bf7\u6c42\u8ba4\u8bc1\u670d\u52a1\u6362\u53d6token\u7ed3\u679c\uff1a{}", (Object)result);
        return Collections.emptyMap();
    }

    protected boolean isAccessTokenBody(Object value) {
        if (value instanceof Map) {
            Map result = (Map)value;
            return result.containsKey("access_token");
        }
        return false;
    }
}

