/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.sms;

import cn.hutool.core.util.RandomUtil;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.SmsCodeEnum;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.messenger.RmiMsgCarrierDubboService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.yst.coord.messenger.sender.provider.param.GeneralDubboCarrier;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SmsCodeProvider {
    private static final Logger log = LogManager.getLogger(SmsCodeProvider.class);
    private final RedisHelper redisHelper;
    private final ConfigProperties configProperties;
    private final RmiMsgCarrierDubboService rmiMsgCarrierDubboService;

    public SmsCodeProvider(RedisHelper redisHelper, ConfigProperties configProperties, RmiMsgCarrierDubboService rmiMsgCarrierDubboService) {
        this.redisHelper = redisHelper;
        this.configProperties = configProperties;
        this.rmiMsgCarrierDubboService = rmiMsgCarrierDubboService;
    }

    public String send(SmsCodeEnum smsCode, String mobile, String code, String content) {
        boolean test;
        Assert.notNull((Object)((Object)smsCode), (String)"\u672a\u77e5\u9a8c\u8bc1\u7801\u7c7b\u578b");
        Assert.hasText((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String key = this.buildCacheKey(smsCode, mobile);
        String value = null;
        try {
            value = (String)this.redisHelper.execute(redisUtils -> redisUtils.get(key));
        }
        catch (Exception e) {
            throw new BusinessException("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25\uff0credis\u670d\u52a1\u5f02\u5e38");
        }
        if (value != null) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41");
        }
        ConfigProperties.Sms sms = this.configProperties.getSms();
        if (!StringUtils.hasText((String)code)) {
            code = RandomUtil.randomStringUpper((int)sms.getCaptchaLength());
        }
        if (!StringUtils.hasText((String)content)) {
            content = sms.getFormatContent();
        }
        long ttl = sms.getTtl().toSeconds();
        content = MessageFormat.format(content, code, ttl);
        String finalCode = code;
        try {
            this.redisHelper.execute(redisUtils -> {
                redisUtils.set(key, (Object)finalCode, ttl);
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25\uff0credis\u670d\u52a1\u5f02\u5e38");
        }
        boolean bl = test = sms.getTest() != null && sms.getTest() != false;
        if (!test) {
            ArrayList<GeneralDubboCarrier> carriers = new ArrayList<GeneralDubboCarrier>();
            GeneralDubboCarrier generalDubboCarrier = new GeneralDubboCarrier();
            generalDubboCarrier.setTos(new String[]{mobile});
            generalDubboCarrier.setPureContent(content);
            generalDubboCarrier.setIsRichContent(Boolean.valueOf(false));
            generalDubboCarrier.setTransType("SMS");
            carriers.add(generalDubboCarrier);
            ApiResult<Object> sendResult = null;
            try {
                sendResult = this.rmiMsgCarrierDubboService.generalSend(carriers);
            }
            catch (Exception e) {
                log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff1a", (Throwable)e);
            }
            if (sendResult == null || !sendResult.isSuccess()) {
                throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            }
            return null;
        }
        return code;
    }

    public boolean verify(SmsCodeEnum smsCode, String mobile, String code) {
        Assert.notNull((Object)((Object)smsCode), (String)"\u672a\u77e5\u9a8c\u8bc1\u7801\u7c7b\u578b");
        Assert.hasText((String)mobile, (String)"\u624b\u673a\u53f7\u4e3a\u7a7a");
        Assert.hasText((String)code, (String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        String key = this.buildCacheKey(smsCode, mobile);
        try {
            return (Boolean)this.redisHelper.execute(redisUtils -> {
                Object theCode = redisUtils.get(key);
                boolean verified = code.equals(theCode);
                if (verified) {
                    try {
                        redisUtils.del(new String[]{key});
                    }
                    catch (Exception e) {
                        log.error("\u5220\u9664\u6821\u9a8c\u901a\u8fc7\u7684\u9a8c\u8bc1\u7801\u3010" + key + "\u3011\u5931\u8d25\uff1a", (Throwable)e);
                    }
                }
                return verified;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25");
        }
    }

    private String buildCacheKey(SmsCodeEnum smsCode, String mobile) {
        return "yst_authorization:SMS_CODE:" + smsCode + ":" + mobile;
    }
}

