/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.task;

import com.elitescloud.cloudt.authorization.api.provider.service.OAuth2AuthenticationService;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class AutoClearExpiredTokenTask
implements SchedulingConfigurer {
    private static final Logger log = LogManager.getLogger(AutoClearExpiredTokenTask.class);
    private final OAuth2AuthenticationService authenticationService;
    private final Duration clearInterval;

    public AutoClearExpiredTokenTask(OAuth2AuthenticationService authenticationService, Duration clearInterval) {
        this.authenticationService = authenticationService;
        this.clearInterval = clearInterval;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        log.info("\u6ce8\u518c\u5b9a\u65f6\u4efb\u52a1\u3010\u81ea\u52a8\u6e05\u7406\u8fc7\u671ftoken\u3011\uff0c\u9891\u7387/{}\u5c0f\u65f6", (Object)this.clearInterval.toHours());
        taskRegistrar.addFixedDelayTask(() -> {
            try {
                this.authenticationService.deleteAllExpiredToken();
            }
            catch (Exception e) {
                log.error("\u6e05\u9664\u8fc7\u671ftoken\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }, this.clearInterval.toMillis());
    }
}

