/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.wechat;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatTool;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.param.WechatAccessToken;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.param.WechatUserInfo;
import com.elitescloud.cloudt.common.exception.BusinessException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public class WechatProvider {
    private static final Logger log = LogManager.getLogger(WechatProvider.class);
    private final WechatTool wechatTool = WechatTool.getInstance();
    private final WechatProperties wechatProperties;

    public WechatProvider(WechatProperties wechatProperties) {
        this.wechatProperties = wechatProperties;
    }

    public WechatUserInfo getUserInfo(@NonNull String appId, @NonNull String code) {
        WechatProperties.App app = this.getApp(appId);
        if (app == null) {
            throw new BusinessException("\u672a\u77e5\u5fae\u4fe1\u5e94\u7528");
        }
        WechatAccessToken accessToken = this.wechatTool.oauth2AccessToken(appId, app.getSecret(), code);
        if (accessToken == null) {
            throw new BusinessException("\u6388\u6743\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c");
        }
        return this.wechatTool.snsUserInfo(accessToken.getAccessToken(), accessToken.getOpenId());
    }

    private WechatProperties.App getApp(String appId) {
        if (CollectionUtils.isEmpty(this.wechatProperties.getApps())) {
            return null;
        }
        for (WechatProperties.App app : this.wechatProperties.getApps()) {
            if (!CharSequenceUtil.equals((CharSequence)appId, (CharSequence)app.getAppid())) continue;
            return app;
        }
        return null;
    }
}

