/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_sms;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.provider.config.system.SmsCodeEnum;
import com.elitescloud.cloudt.authorization.api.provider.provider.sms.SmsCodeProvider;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_sms.MobileSmsAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class MobileSmsAuthenticationProvider
extends AbstractCustomAuthenticationProvider<MobileSmsAuthenticationToken> {
    @Autowired
    private SmsCodeProvider smsCodeManager;

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(MobileSmsAuthenticationToken authentication) throws AuthenticationException {
        String mobile = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)mobile)) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        String smsCode = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)smsCode)) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        boolean verify = this.smsCodeManager.verify(SmsCodeEnum.LOGIN, mobile, smsCode);
        if (!verify) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        return this.userDetailManager.loadUserByMobile(mobile);
    }
}

