/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_sms;

import com.elitescloud.cloudt.authorization.api.client.common.LoginType;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitescloud.cloudt.common.constant.Terminal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class MobileSmsAuthenticationToken
extends AbstractCustomAuthenticationToken<MobileSmsAuthenticationToken> {
    private static final long serialVersionUID = -8359205420429608593L;

    public MobileSmsAuthenticationToken() {
        super(null, null);
    }

    public MobileSmsAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public MobileSmsAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.MOBILE_SMS;
    }

    @NonNull
    public MobileSmsAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.valueOf((String)terminalParam);
        }
        MobileSmsAuthenticationToken authenticationToken = new MobileSmsAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"mobile"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"sms_code"));
        authenticationToken.setAuthenticated(false);
        return authenticationToken;
    }
}

