/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.grant.wx_minapp;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.param.WechatUserInfo;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.wx_minapp.WechatOpenidAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class WechatOpenidAuthenticationProvider
extends AbstractCustomAuthenticationProvider<WechatOpenidAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(WechatOpenidAuthenticationProvider.class);
    @Autowired
    private WechatProvider wechatProvider;
    @Autowired
    private UserDetailManager userDetailManager;

    @Override
    protected GeneralUserDetails retrieveUser(WechatOpenidAuthenticationToken authentication) throws AuthenticationException {
        String openId = authentication.getOpenId();
        String appId = (String)authentication.getPrincipal();
        String wxCode = (String)authentication.getCredentials();
        if (StringUtils.hasText((String)openId)) {
            return this.userDetailManager.loadUserByWechatOpenid(openId);
        }
        if (!StringUtils.hasText((String)appId) || !StringUtils.hasText((String)wxCode)) {
            throw new AuthorizationException("\u8bf7\u6c42\u6709\u8bef\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        openId = this.obtainOpenid(appId, wxCode);
        return this.userDetailManager.loadUserByWechatOpenid(openId);
    }

    private String obtainOpenid(String appId, String wxCode) {
        try {
            WechatUserInfo userInfo = this.wechatProvider.getUserInfo(appId, wxCode);
            if (userInfo != null) {
                return userInfo.getOpenid();
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("\u5fae\u4fe1\u670d\u52a1\u6388\u6743\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

