/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.handler;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationSuccessHandler;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.model.OAuthToken;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;

public class JwtAuthenticationSuccessHandler
extends DefaultAuthenticationSuccessHandler {
    private final TokenGenerator tokenGenerator;

    public JwtAuthenticationSuccessHandler(AuthorizationProperties authorizationProperties, DelegateAuthenticationCallable authenticationCallable, TokenGenerator tokenGenerator) {
        super(authorizationProperties, authenticationCallable);
        this.tokenGenerator = tokenGenerator;
    }

    protected Object convertResponseResult(HttpServletRequest request, Authentication authentication) {
        if (this.tokenGenerator == null) {
            return super.convertResponseResult(request, authentication);
        }
        return this.tokenGenerator.generate(authentication);
    }

    protected String generateToken(HttpServletRequest request, Object responseResult, Authentication authentication) {
        if (responseResult instanceof OAuthToken) {
            OAuthToken authToken = (OAuthToken)responseResult;
            return authToken.getAccessToken();
        }
        return super.generateToken(request, responseResult, authentication);
    }
}

