/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.impl;

import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.AuthenticationService;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class DefaultAuthenticationService
implements AuthenticationService {
    private final DelegateAuthenticationCallable authenticationCallable;

    public DefaultAuthenticationService(DelegateAuthenticationCallable authenticationCallable) {
        this.authenticationCallable = authenticationCallable;
    }

    @Override
    public ApiResult<String> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = SecurityContextUtil.currentToken();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (StringUtils.hasText((String)token) && user != null) {
            this.authenticationCallable.onLogout(request, response, token, (Object)user);
            return ApiResult.ok((Object)user.getUsername());
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<GeneralUserDetails> currentUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        user.getUser().setPassword("");
        return ApiResult.ok((Object)user);
    }
}

