/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import com.elitescloud.cloudt.authorization.api.provider.model.entity.OAuth2AuthorizationConsentDO;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.BaseCustomAuthorizationService;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthorizationConsentRepo;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2AuthorizationConsentRepoProc;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class JpaOAuth2AuthorizationConsentService
extends BaseCustomAuthorizationService
implements OAuth2AuthorizationConsentService {
    private static final Logger log = LogManager.getLogger(JpaOAuth2AuthorizationConsentService.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationConsentRepo oAuth2AuthorizationConsentRepo;
    private final OAuth2AuthorizationConsentRepoProc oAuth2AuthorizationConsentRepoProc;

    public JpaOAuth2AuthorizationConsentService(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationConsentRepo oAuth2AuthorizationConsentRepo, OAuth2AuthorizationConsentRepoProc oAuth2AuthorizationConsentRepoProc) {
        this.registeredClientRepository = registeredClientRepository;
        this.oAuth2AuthorizationConsentRepo = oAuth2AuthorizationConsentRepo;
        this.oAuth2AuthorizationConsentRepoProc = oAuth2AuthorizationConsentRepoProc;
    }

    public void save(OAuth2AuthorizationConsent authorizationConsent) {
        if (authorizationConsent == null) {
            log.error("\u4fdd\u5b58\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        Assert.hasText((String)authorizationConsent.getPrincipalName(), (String)"principal\u4e3a\u7a7a");
        Assert.hasText((String)authorizationConsent.getRegisteredClientId(), (String)"clientId\u4e3a\u7a7a");
        OAuth2AuthorizationConsentDO consentDO = this.toDo(authorizationConsent);
        this.oAuth2AuthorizationConsentRepo.save(consentDO);
    }

    public void remove(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.hasText((String)authorizationConsent.getPrincipalName(), (String)"principal\u4e3a\u7a7a");
        Assert.hasText((String)authorizationConsent.getRegisteredClientId(), (String)"clientId\u4e3a\u7a7a");
        this.oAuth2AuthorizationConsentRepoProc.delete(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName());
    }

    public OAuth2AuthorizationConsent findById(String registeredClientId, String principalName) {
        Assert.hasText((String)principalName, (String)"principal\u4e3a\u7a7a");
        Assert.hasText((String)registeredClientId, (String)"clientId\u4e3a\u7a7a");
        OAuth2AuthorizationConsentDO consentDO = this.oAuth2AuthorizationConsentRepoProc.get(registeredClientId, principalName);
        return this.toBo(consentDO);
    }

    private OAuth2AuthorizationConsentDO toDo(OAuth2AuthorizationConsent authorizationConsent) {
        OAuth2AuthorizationConsentDO consentDO = new OAuth2AuthorizationConsentDO();
        String id = this.oAuth2AuthorizationConsentRepoProc.getId(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName());
        consentDO.setId(CharSequenceUtil.blankToDefault((CharSequence)id, (String)IdUtil.fastSimpleUUID()));
        consentDO.setRegisteredClientId(authorizationConsent.getRegisteredClientId());
        consentDO.setPrincipalName(authorizationConsent.getPrincipalName());
        if (!CollectionUtils.isEmpty((Collection)authorizationConsent.getAuthorities())) {
            Set authorities = authorizationConsent.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
            consentDO.setAuthorities(this.toJsonString(authorities));
        }
        return consentDO;
    }

    private OAuth2AuthorizationConsent toBo(OAuth2AuthorizationConsentDO authorizationConsentDo) {
        if (authorizationConsentDo == null) {
            return null;
        }
        Assert.hasText((String)authorizationConsentDo.getRegisteredClientId(), (String)"clientId\u4e3a\u7a7a");
        RegisteredClient client = this.registeredClientRepository.findById(authorizationConsentDo.getRegisteredClientId());
        Assert.notNull((Object)client, (String)"client\u4e0d\u5b58\u5728");
        OAuth2AuthorizationConsent.Builder builder = OAuth2AuthorizationConsent.withId((String)authorizationConsentDo.getRegisteredClientId(), (String)authorizationConsentDo.getPrincipalName());
        if (StringUtils.hasText((String)authorizationConsentDo.getAuthorities())) {
            Set<String> authorities = this.toJsonObj(authorizationConsentDo.getAuthorities(), new TypeReference<Set<String>>(){});
            for (String authority : authorities) {
                builder.authority((GrantedAuthority)new SimpleGrantedAuthority(authority));
            }
        }
        return builder.build();
    }
}

