/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import com.elitescloud.cloudt.authorization.api.provider.model.entity.OAuth2RegisteredClientDO;
import com.elitescloud.cloudt.authorization.api.provider.service.impl.BaseCustomAuthorizationService;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2RegisteredClientRepo;
import com.elitescloud.cloudt.authorization.api.provider.service.repository.OAuth2RegisteredClientRepoProc;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ClientSettings;
import org.springframework.security.oauth2.server.authorization.config.ConfigurationSettingNames;
import org.springframework.security.oauth2.server.authorization.config.TokenSettings;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class JpaRegisteredClientRepository
extends BaseCustomAuthorizationService
implements RegisteredClientRepository {
    private static final Logger log = LogManager.getLogger(JpaRegisteredClientRepository.class);
    private final OAuth2RegisteredClientRepo oAuth2RegisteredClientRepo;
    private final OAuth2RegisteredClientRepoProc oAuth2RegisteredClientRepoProc;
    private final Cache<String, RegisteredClient> clientCacheForId = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofHours(2L)).build();
    private final Cache<String, RegisteredClient> clientCacheForClientId = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofHours(2L)).build();

    public JpaRegisteredClientRepository(OAuth2RegisteredClientRepo oAuth2RegisteredClientRepo, OAuth2RegisteredClientRepoProc oAuth2RegisteredClientRepoProc) {
        this.oAuth2RegisteredClientRepo = oAuth2RegisteredClientRepo;
        this.oAuth2RegisteredClientRepoProc = oAuth2RegisteredClientRepoProc;
    }

    public void save(RegisteredClient registeredClient) {
        if (registeredClient == null) {
            log.error("\u4fdd\u5b58RegisteredClient\u4e3a\u7a7a");
            return;
        }
        Assert.hasText((String)registeredClient.getClientId(), (String)"clientId\u4e3a\u7a7a");
        boolean exists = this.oAuth2RegisteredClientRepoProc.existsClientId(registeredClient.getClientId(), registeredClient.getId());
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"clientId\u5df2\u5b58\u5728");
        OAuth2RegisteredClientDO registeredClientDO = this.toDo(registeredClient);
        this.oAuth2RegisteredClientRepo.save(registeredClientDO);
    }

    public RegisteredClient findById(String id) {
        if (!StringUtils.hasText((String)id)) {
            log.error("ID\u4e3a\u7a7a");
            return null;
        }
        RegisteredClient client = (RegisteredClient)this.clientCacheForId.getIfPresent((Object)id);
        if (client != null) {
            return client;
        }
        OAuth2RegisteredClientDO clientDO = this.oAuth2RegisteredClientRepo.findById(id).orElse(null);
        if (clientDO == null) {
            log.warn("RegisteredClient\u3010{}\u3011\u4e0d\u5b58\u5728", (Object)id);
            return null;
        }
        client = this.toBo(clientDO);
        this.clientCacheForId.put((Object)id, (Object)client);
        return client;
    }

    public RegisteredClient findByClientId(String clientId) {
        if (!StringUtils.hasText((String)clientId)) {
            log.error("clientId\u4e3a\u7a7a");
            return null;
        }
        RegisteredClient client = (RegisteredClient)this.clientCacheForClientId.getIfPresent((Object)clientId);
        if (client != null) {
            return client;
        }
        OAuth2RegisteredClientDO clientDO = this.oAuth2RegisteredClientRepoProc.getByClientId(clientId);
        if (clientDO == null) {
            log.warn("RegisteredClient\u3010{}\u3011\u4e0d\u5b58\u5728", (Object)clientId);
            return null;
        }
        client = this.toBo(clientDO);
        this.clientCacheForClientId.put((Object)clientId, (Object)client);
        return client;
    }

    private OAuth2RegisteredClientDO toDo(RegisteredClient registeredClient) {
        OAuth2RegisteredClientDO clientDO = new OAuth2RegisteredClientDO();
        clientDO.setId(CharSequenceUtil.blankToDefault((CharSequence)registeredClient.getId(), (String)IdUtil.fastSimpleUUID()));
        clientDO.setClientId(registeredClient.getClientId());
        clientDO.setClientIdIssuedAt(this.toLocalDateTime(registeredClient.getClientIdIssuedAt()));
        clientDO.setClientSecret(registeredClient.getClientSecret());
        clientDO.setClientSecretExpiresAt(this.toLocalDateTime(registeredClient.getClientSecretExpiresAt()));
        clientDO.setClientName(registeredClient.getClientName());
        if (!CollectionUtils.isEmpty((Collection)registeredClient.getClientAuthenticationMethods())) {
            String methods = registeredClient.getClientAuthenticationMethods().stream().map(ClientAuthenticationMethod::getValue).collect(Collectors.joining(","));
            clientDO.setClientAuthenticationMethods(methods);
        }
        if (!CollectionUtils.isEmpty((Collection)registeredClient.getAuthorizationGrantTypes())) {
            String grantTypes = registeredClient.getAuthorizationGrantTypes().stream().map(AuthorizationGrantType::getValue).collect(Collectors.joining(","));
            clientDO.setAuthorizationGrantTypes(grantTypes);
        }
        clientDO.setRedirectUris(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getRedirectUris()));
        clientDO.setScopes(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getScopes()));
        clientDO.setClientSettings(this.toJsonString(registeredClient.getClientSettings().getSettings()));
        clientDO.setTokenSettings(this.toJsonString(registeredClient.getTokenSettings().getSettings()));
        return clientDO;
    }

    private RegisteredClient toBo(OAuth2RegisteredClientDO clientDO) {
        Set clientAuthenticationMethods = StringUtils.commaDelimitedListToSet((String)clientDO.getClientAuthenticationMethods());
        Set authorizationGrantTypes = StringUtils.commaDelimitedListToSet((String)clientDO.getAuthorizationGrantTypes());
        Set redirectUris = StringUtils.commaDelimitedListToSet((String)clientDO.getRedirectUris());
        Set clientScopes = StringUtils.commaDelimitedListToSet((String)clientDO.getScopes());
        RegisteredClient.Builder builder = RegisteredClient.withId((String)clientDO.getId()).clientId(clientDO.getClientId()).clientIdIssuedAt(this.toInstant(clientDO.getClientIdIssuedAt())).clientSecret(clientDO.getClientSecret()).clientSecretExpiresAt(this.toInstant(clientDO.getClientSecretExpiresAt())).clientName(clientDO.getClientName()).clientAuthenticationMethods(authenticationMethods -> clientAuthenticationMethods.forEach(authenticationMethod -> authenticationMethods.add(new ClientAuthenticationMethod(authenticationMethod)))).authorizationGrantTypes(grantTypes -> authorizationGrantTypes.forEach(grantType -> grantTypes.add(new AuthorizationGrantType(grantType)))).redirectUris(uris -> uris.addAll(redirectUris)).scopes(scopes -> scopes.addAll(clientScopes));
        Map<String, Object> clientSettingsMap = this.toJsonObj(clientDO.getClientSettings(), new TypeReference<Map<String, Object>>(){});
        builder.clientSettings(ClientSettings.withSettings(clientSettingsMap).build());
        Map<String, Object> tokenSettingsMap = this.toJsonObj(clientDO.getTokenSettings(), new TypeReference<Map<String, Object>>(){});
        TokenSettings.Builder tokenSettingsBuilder = TokenSettings.withSettings(tokenSettingsMap);
        if (!tokenSettingsMap.containsKey(ConfigurationSettingNames.Token.ACCESS_TOKEN_FORMAT)) {
            tokenSettingsBuilder.accessTokenFormat(OAuth2TokenFormat.SELF_CONTAINED);
        }
        builder.tokenSettings(tokenSettingsBuilder.build());
        return builder.build();
    }
}

