/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.web.controller;

import com.elitescloud.cloudt.authorization.api.client.model.OAuthToken;
import com.elitescloud.cloudt.authorization.api.provider.model.vo.resp.OAuth2SettingRespVO;
import com.elitescloud.cloudt.authorization.api.provider.provider.oauth2.client.OAuth2ClientProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@ResponseBody
@RequestMapping(value={"/oauth2/login"}, produces={"application/json"})
@Validated
@Api(tags={"OAuth2\u8ba4\u8bc1\u76f8\u5173\u63a5\u53e3"})
@ApiIgnore
public class OAuth2LoginSupportController {
    private final OAuth2ClientProvider oAuth2ClientProvider;

    public OAuth2LoginSupportController(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
    }

    @GetMapping(value={"/setting"})
    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e")
    public ApiResult<OAuth2SettingRespVO> getSetting() {
        return ApiResult.ok((Object)this.oAuth2ClientProvider.getSettings());
    }

    @GetMapping(value={"/code2token"})
    @ApiOperation(value="\u6388\u6743\u7801\u6362\u53d6token")
    public ApiResult<OAuthToken> code2Token(@RequestParam(value="clientId") @NotBlank(message="\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a") String clientId, @RequestParam(value="code") @NotBlank(message="\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a") String code, @RequestParam(value="redirectUri") @NotBlank(message="\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a") String redirectUri, @RequestParam(value="codeVerifier", required=false) String codeVerifier) {
        return this.oAuth2ClientProvider.code2AccessToken(clientId, code, redirectUri, codeVerifier);
    }
}

