/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.cas.provider;

import com.elitescloud.cloudt.authorization.sdk.cas.AuthorizeCacheable;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthorizeDTO;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.b;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.c;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.d;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.e;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.f;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.g;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.h;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.config.CloudtOAuth2Client;
import com.elitescloud.cloudt.authorization.sdk.model.OAuthToken;
import com.elitescloud.cloudt.authorization.sdk.model.Result;
import com.elitescloud.cloudt.authorization.sdk.resolver.UniqueRequestResolver;
import com.elitescloud.cloudt.authorization.sdk.resolver.impl.DefaultUniquestResolver;
import com.elitescloud.cloudt.authorization.sdk.util.RestTemplateFactory;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2ClientProvider
implements InitializingBean {
    private static final Logger a = LoggerFactory.getLogger(OAuth2ClientProvider.class);
    private static final String b = "abcdefghijklmnopqrstuvwxyz";
    private final AuthorizationSdkProperties c;
    private final AuthorizeCacheable d;
    private final MessageDigest e;
    private UniqueRequestResolver f = new DefaultUniquestResolver("X-Auth-Req-Client");
    private RestTemplate g;
    private b h;

    public OAuth2ClientProvider(AuthorizationSdkProperties authorizationSdkProperties, AuthorizeCacheable authorizeCacheable) {
        this.c = authorizationSdkProperties;
        this.d = authorizeCacheable == null ? new a() : authorizeCacheable;
        try {
            this.e = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public String getAuthorizeInfo(@NotNull HttpServletResponse httpServletResponse, @NotBlank String string, String string2) {
        if (this.h == null) {
            this.a();
        }
        String string3 = this.f.signRequest(httpServletResponse);
        AuthorizeDTO authorizeDTO = new AuthorizeDTO();
        authorizeDTO.setAuthorizeEndpoint(this.h.a());
        authorizeDTO.setClientId(this.c.getCasClient().getOauth2Client().getClientId());
        authorizeDTO.setResponseType("code");
        authorizeDTO.setScope("openid");
        authorizeDTO.setRedirectUri(string);
        if (this.c.getCasClient().getOauth2Client().isPkceEnabled()) {
            authorizeDTO.setCodeVerifier(this.d());
            authorizeDTO.setCodeChallengeMethod("S256");
            authorizeDTO.setCodeChallenge(this.c(authorizeDTO.getCodeVerifier()));
        }
        authorizeDTO.setState(string2);
        this.d.setCache(string3, authorizeDTO);
        return authorizeDTO.getUrl();
    }

    public Result<OAuthToken> code2AccessToken(@NotNull HttpServletRequest httpServletRequest, @NotBlank String string) {
        String string2 = this.f.analyze(httpServletRequest);
        Assert.hasText((String)string2, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u8bf7\u6c42\u6807\u8bc6");
        AuthorizeDTO authorizeDTO = this.d.get(string2);
        Assert.notNull((Object)authorizeDTO, (String)"\u8ba4\u8bc1\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap(8);
        linkedMultiValueMap.add((Object)"client_id", (Object)authorizeDTO.getClientId());
        linkedMultiValueMap.add((Object)"client_secret", (Object)this.c.getCasClient().getOauth2Client().getClientSecret());
        linkedMultiValueMap.add((Object)"grant_type", (Object)AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
        linkedMultiValueMap.add((Object)"code", (Object)string);
        String string3 = authorizeDTO.getRedirectUri();
        if (StringUtils.hasText((String)string3)) {
            linkedMultiValueMap.add((Object)"redirect_uri", (Object)string3);
        }
        if (StringUtils.hasText((String)authorizeDTO.getCodeVerifier())) {
            linkedMultiValueMap.add((Object)"code_verifier", (Object)authorizeDTO.getCodeVerifier());
        }
        try {
            ResponseEntity responseEntity = this.g.exchange(this.h.b(), HttpMethod.POST, new HttpEntity((Object)linkedMultiValueMap), (ParameterizedTypeReference)new c(this), new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Result.ok((OAuthToken)responseEntity.getBody());
            }
            a.error("\u6388\u6743\u7801\u8f6ctoken\u5931\u8d25\uff1a{}", (Object)responseEntity);
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25");
        }
        catch (Exception exception) {
            a.error("\u83b7\u53d6\u8ba4\u8bc1token\u5f02\u5e38\uff1a", (Throwable)exception);
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5f02\u5e38\uff01");
        }
    }

    public Result<HashMap<String, String>> queryUserInfo(@NotBlank String string, @NotBlank String string2) {
        Assert.hasText((String)string, (String)"token\u7c7b\u578b\u4e3a\u7a7a");
        Assert.hasText((String)string2, (String)"token\u4e3a\u7a7a");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap(4);
        linkedMultiValueMap.add((Object)"Authorization", (Object)(string + " " + string2));
        try {
            ResponseEntity responseEntity = this.g.exchange(this.h.c(), HttpMethod.GET, new HttpEntity(null, (MultiValueMap)linkedMultiValueMap), (ParameterizedTypeReference)new d(this), new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Result.ok((HashMap)responseEntity.getBody());
            }
            a.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)responseEntity);
            return Result.fail("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        catch (Exception exception) {
            a.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)exception);
            return Result.fail("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
        }
    }

    public Result<OAuthToken> refreshToken(@NotBlank String string) {
        Assert.notNull((Object)string, (String)"\u5237\u65b0token\u4e3a\u7a7a");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap(8);
        linkedMultiValueMap.add((Object)"client_id", (Object)this.c.getCasClient().getOauth2Client().getClientId());
        linkedMultiValueMap.add((Object)"client_secret", (Object)this.c.getCasClient().getOauth2Client().getClientSecret());
        linkedMultiValueMap.add((Object)"grant_type", (Object)AuthorizationGrantType.REFRESH_TOKEN.getValue());
        linkedMultiValueMap.add((Object)"refresh_token", (Object)string);
        try {
            ResponseEntity responseEntity = this.g.exchange(this.h.b(), HttpMethod.POST, new HttpEntity((Object)linkedMultiValueMap), (ParameterizedTypeReference)new e(this), new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Result.ok((OAuthToken)responseEntity.getBody());
            }
            a.error("\u5237\u65b0token\u5931\u8d25\uff1a{}", (Object)responseEntity);
            return Result.fail("\u5237\u65b0token\u5931\u8d25");
        }
        catch (Exception exception) {
            a.error("\u5237\u65b0token\u5f02\u5e38\uff1a", (Throwable)exception);
            return Result.fail("\u5237\u65b0\u8ba4\u8bc1token\u5f02\u5e38\uff01");
        }
    }

    public Result<OAuthToken> clientToken() {
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap(8);
        linkedMultiValueMap.add((Object)"grant_type", (Object)AuthorizationGrantType.CLIENT_CREDENTIALS.getValue());
        linkedMultiValueMap.add((Object)"client_id", (Object)this.c.getCasClient().getOauth2Client().getClientId());
        linkedMultiValueMap.add((Object)"client_secret", (Object)this.c.getCasClient().getOauth2Client().getClientSecret());
        try {
            ResponseEntity responseEntity = this.g.exchange(this.h.b(), HttpMethod.POST, new HttpEntity((Object)linkedMultiValueMap), (ParameterizedTypeReference)new f(this), new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Result.ok((OAuthToken)responseEntity.getBody());
            }
            a.error("\u751f\u6210token\u5931\u8d25\uff1a{}", (Object)responseEntity.getStatusCode());
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25");
        }
        catch (Exception exception) {
            a.error("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff1a", (Throwable)exception);
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff01");
        }
    }

    public Result<Boolean> revokeToken(@NotBlank String string) {
        Assert.hasText((String)string, (String)"token\u4e3a\u7a7a");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap(8);
        linkedMultiValueMap.add((Object)"client_id", (Object)this.c.getCasClient().getOauth2Client().getClientId());
        linkedMultiValueMap.add((Object)"client_secret", (Object)this.c.getCasClient().getOauth2Client().getClientSecret());
        linkedMultiValueMap.add((Object)"token", (Object)string);
        try {
            ResponseEntity responseEntity = this.g.exchange(this.h.d(), HttpMethod.POST, new HttpEntity((Object)linkedMultiValueMap), (ParameterizedTypeReference)new g(this), new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Result.ok(true);
            }
            a.error("\u6ce8\u9500token\u5931\u8d25\uff1a{}", (Object)responseEntity.getStatusCode());
            return Result.fail("\u6ce8\u9500token\u5931\u8d25");
        }
        catch (Exception exception) {
            a.error("\u6ce8\u9500token\u5931\u8d25\uff1a", (Throwable)exception);
            return Result.fail("\u6ce8\u9500token\u5931\u8d25\uff01");
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.c.getCasClient().getOauth2Client().isPkceEnabled()) {
            Assert.hasText((String)this.c.getCasClient().getOauth2Client().getClientSecret(), (String)"OAuth2 Client\u7684clientSecret\u4e3a\u7a7a");
        }
        CompletableFuture.runAsync(this::a).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                a.error("\u521d\u59cb\u5316OAuth2\u5ba2\u6237\u7aef\u5f02\u5e38\uff1a", throwable);
            }
        });
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.f = uniqueRequestResolver;
    }

    private void a() {
        if (this.g == null) {
            this.g = RestTemplateFactory.instance();
        }
        String string = this.b();
        this.h = this.a(string);
    }

    private String b() {
        return this.c.getAuthServer();
    }

    private b a(String string) {
        b b2 = new b();
        CloudtOAuth2Client cloudtOAuth2Client = this.c.getCasClient().getOauth2Client();
        b2.a(this.a(string, cloudtOAuth2Client.getAuthorizeEndpoint()));
        if (StringUtils.hasText((String)b2.a())) {
            b2.b(this.a(string, cloudtOAuth2Client.getTokenEndpoint()));
            b2.c(this.a(string, cloudtOAuth2Client.getUserinfoEndpoint()));
            return b2;
        }
        Assert.hasText((String)string, (String)"\u672a\u77e5\u8ba4\u8bc1\u670d\u52a1\u5668\u5730\u5740");
        Map<String, Object> map = this.b(this.a(string, "/.well-known/openid-configuration"));
        b2.a((String)map.get("authorization_endpoint"));
        Assert.hasText((String)b2.a(), (String)"OAuth2\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25");
        b2.b((String)map.get("token_endpoint"));
        b2.c((String)map.get("userinfo_endpoint"));
        b2.d((String)map.get("revocation_endpoint"));
        return b2;
    }

    private Map<String, Object> b(String string) {
        try {
            ResponseEntity responseEntity = this.g.exchange(string, HttpMethod.GET, null, (ParameterizedTypeReference)new h(this), new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                a.info("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u6210\u529f\uff1a{}", responseEntity.getBody());
                return (Map)responseEntity.getBody();
            }
            a.warn("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)responseEntity.getStatusCode());
        }
        catch (Exception exception) {
            a.error("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5f02\u5e38", (Throwable)exception);
        }
        return Collections.emptyMap();
    }

    private String c() {
        String string = "" + System.nanoTime();
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i2 = 0; i2 < 8; ++i2) {
            stringBuilder.append(random.nextInt(10));
        }
        return stringBuilder.toString();
    }

    private String d() {
        int n2 = b.length();
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 10; ++i2) {
            stringBuilder.append(b.charAt(random.nextInt(n2)));
        }
        return stringBuilder.toString();
    }

    private String c(String string) {
        byte[] byArray = this.e.digest(string.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(byArray);
    }

    private String a(String string, String string2) {
        if (!StringUtils.hasText((String)string2)) {
            return null;
        }
        if (!string2.toLowerCase().startsWith("http") && !string2.toLowerCase().startsWith("https")) {
            Assert.hasText((String)string, (String)"\u672a\u77e5\u8ba4\u8bc1\u670d\u52a1\u5668\u5730\u5740");
        }
        string = string == null ? "" : string;
        return UriComponentsBuilder.fromUriString((String)(string + "/" + string2)).toUriString();
    }

    static class a
    implements AuthorizeCacheable {
        private final Cache<String, AuthorizeDTO> a = Caffeine.newBuilder().maximumSize(2000L).expireAfterWrite(Duration.ofMinutes(5L)).build();

        @Override
        public void setCache(String string, AuthorizeDTO authorizeDTO) {
            this.a.put((Object)string, (Object)authorizeDTO);
        }

        @Override
        public AuthorizeDTO get(String string) {
            return (AuthorizeDTO)this.a.getIfPresent((Object)string);
        }
    }
}

