/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.cas.provider;

import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.i;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.j;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.k;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.l;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.m;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.n;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.o;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.p;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.q;
import com.elitescloud.cloudt.authorization.sdk.cas.task.ClientTokenHolder;
import com.elitescloud.cloudt.authorization.sdk.model.OAuthToken;
import com.elitescloud.cloudt.authorization.sdk.model.Result;
import com.elitescloud.cloudt.authorization.sdk.util.RestTemplateFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public final class UserTransferHelper {
    private static final Logger a = LoggerFactory.getLogger(UserTransferHelper.class);
    private static UserTransferHelper b = null;
    private final RestTemplate c = RestTemplateFactory.instance(restTemplateBuilder -> restTemplateBuilder.rootUri(string).additionalInterceptors(new ClientHttpRequestInterceptor[]{new a()}));

    private UserTransferHelper(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserTransferHelper getInstance(@NotBlank String string) {
        if (b != null) return b;
        Class<UserTransferHelper> clazz = UserTransferHelper.class;
        synchronized (UserTransferHelper.class) {
            if (b != null) return b;
            b = new UserTransferHelper(string);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return b;
        }
    }

    public Result<Long> upsertUser(@NotNull AuthUserDTO authUserDTO) {
        Assert.notNull((Object)authUserDTO, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        return this.a("/rpc/cloudt/authorization/user/upsertUser", HttpMethod.POST, new HttpEntity((Object)authUserDTO), new i(this), new Object[0]);
    }

    public Result<HashMap<String, Long>> upsertUserBatch(boolean bl, @NotEmpty List<AuthUserDTO> list) {
        Assert.notEmpty(list, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        return this.a("/rpc/cloudt/authorization/user/upsertUser/batch?rollBackAllOnException={rollBackAllOnException}", HttpMethod.POST, new HttpEntity(list), new j(this), bl);
    }

    public Result<Long> updateEnabled(long l2, boolean bl) {
        return this.a("/rpc/cloudt/authorization/user/update/enabled?userId={userId}&enabled={enabled}", HttpMethod.PATCH, null, new k(this), l2, bl);
    }

    public Result<Long> updatePassword(long l2, @NotBlank String string) {
        Assert.hasText((String)string, (String)"\u5bc6\u7801\u4e3a\u7a7a");
        return this.a("/rpc/cloudt/authorization/user/update/pwd?userId={userId}&pd={pd}", HttpMethod.PATCH, null, new l(this), l2, string);
    }

    public Result<Long> updateExpiredTime(long l2, @NotBlank String string) {
        Assert.hasText((String)string, (String)"\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
        return this.a("/rpc/cloudt/authorization/user/update/expiredTime?userId={userId}&expiredTime={expiredTime}", HttpMethod.PATCH, null, new m(this), l2, string);
    }

    public Result<Long> updatePwdExpiredTime(long l2, String string) {
        Assert.hasText((String)string, (String)"\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
        return this.a("/rpc/cloudt/authorization/user/update/pwd/expiredTime?userId={userId}&expiredTime={expiredTime}", HttpMethod.PATCH, null, new n(this), l2, string);
    }

    public Result<Long> delete(long l2) {
        return this.a("/rpc/cloudt/authorization/user/delete?userId={userId}", HttpMethod.DELETE, null, new o(this), l2);
    }

    public Result<AuthUserDTO> getUser(long l2) {
        return this.a("/rpc/cloudt/authorization/user/getUser?userId={userId}", HttpMethod.GET, null, new p(this), l2);
    }

    public Result<ArrayList<AuthUserDTO>> getUserList(@NotEmpty List<Long> list) {
        Assert.notEmpty(list, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        return this.a("/rpc/cloudt/authorization/user/getUserList", HttpMethod.POST, new HttpEntity(list), new q(this), new Object[0]);
    }

    private <T> T a(T t, T t2) {
        return t == null ? t2 : t;
    }

    private <T> T a(String string, HttpMethod httpMethod, HttpEntity<?> httpEntity, ParameterizedTypeReference<T> parameterizedTypeReference, Object ... objectArray) {
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.c.exchange(string, httpMethod, httpEntity, parameterizedTypeReference, objectArray);
        }
        catch (RestClientException restClientException) {
            a.error("\u8ba4\u8bc1\u6388\u6743\u670d\u52a1\u5668\u8c03\u7528\u5931\u8d25\uff1a", (Throwable)restClientException);
            throw new RuntimeException("\u8ba4\u8bc1\u6388\u6743\u670d\u52a1\u5668\u5f02\u5e38", restClientException);
        }
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            a.error("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5668\u63a5\u53e3\u5931\u8d25\uff1a{}, {}", (Object)string, (Object)responseEntity);
            throw new RuntimeException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5668\u63a5\u53e3\u5931\u8d25");
        }
        return (T)responseEntity.getBody();
    }

    static class a
    implements ClientHttpRequestInterceptor {
        a() {
        }

        @NonNull
        public ClientHttpResponse intercept(HttpRequest httpRequest, @NonNull byte[] byArray, @NonNull ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
            HttpHeaders httpHeaders = httpRequest.getHeaders();
            OAuthToken oAuthToken = ClientTokenHolder.getToken();
            if (oAuthToken == null) {
                throw new IllegalStateException("Token\u83b7\u53d6\u5931\u8d25");
            }
            httpHeaders.add("Authorization", oAuthToken.getTokenType() + " " + oAuthToken.getAccessToken());
            return clientHttpRequestExecution.execute(httpRequest, byArray);
        }
    }
}

