/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.cas.task;

import com.elitescloud.cloudt.authorization.sdk.cas.UserSourceProvider;
import com.elitescloud.cloudt.authorization.sdk.cas.config.CasClientProperties;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.OAuth2ClientProvider;
import com.elitescloud.cloudt.authorization.sdk.cas.task.AutoRefreshClientTokenTask;
import com.elitescloud.cloudt.authorization.sdk.cas.task.AutoSyncUserTask;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class CasClientScheduler
implements SchedulingConfigurer {
    private static final Logger a = LoggerFactory.getLogger(CasClientScheduler.class);
    private final AuthorizationSdkProperties b;
    private UserSourceProvider c;
    private OAuth2ClientProvider d;

    public CasClientScheduler(AuthorizationSdkProperties authorizationSdkProperties) {
        this.b = authorizationSdkProperties;
    }

    public void configureTasks(@NonNull ScheduledTaskRegistrar scheduledTaskRegistrar) {
        this.b(scheduledTaskRegistrar);
        this.a(scheduledTaskRegistrar);
    }

    private void a(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        long l2;
        if (this.c == null) {
            return;
        }
        CasClientProperties casClientProperties = this.b.getCasClient();
        long l3 = l2 = casClientProperties.getSyncInterval() == null ? 0L : casClientProperties.getSyncInterval().toMillis();
        if (l2 < 1L) {
            a.warn("CAS\u81ea\u52a8\u540c\u6b65\u7528\u6237\u5df2\u5173\u95ed");
            return;
        }
        AutoSyncUserTask autoSyncUserTask = new AutoSyncUserTask(this.b.getAuthServer(), this.c);
        scheduledTaskRegistrar.addFixedDelayTask(() -> {
            if (!Boolean.TRUE.equals(this.b.getCasClient().getEnabled())) {
                return;
            }
            try {
                autoSyncUserTask.setSyncSize(casClientProperties.getSyncSize());
                autoSyncUserTask.setRollbackAllOnException(Boolean.TRUE.equals(casClientProperties.getRollBackAllOnException()));
                autoSyncUserTask.run();
            }
            catch (Exception exception) {
                a.error("\u6267\u884c\u540c\u6b65\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)exception);
            }
        }, l2);
    }

    private void b(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        long l2;
        if (this.d == null) {
            return;
        }
        long l3 = l2 = this.b.getCasClient().getClientTokenInterval() == null ? 0L : this.b.getCasClient().getClientTokenInterval().toMillis();
        if (l2 < 1L) {
            a.warn("CAS\u81ea\u52a8\u540c\u6b65\u5237\u65b0\u5ba2\u6237\u7aeftoken\u5df2\u5173\u95ed");
            return;
        }
        AutoRefreshClientTokenTask autoRefreshClientTokenTask = new AutoRefreshClientTokenTask(this.d);
        scheduledTaskRegistrar.addFixedDelayTask(() -> {
            if (!Boolean.TRUE.equals(this.b.getCasClient().getEnabled())) {
                return;
            }
            try {
                autoRefreshClientTokenTask.run();
            }
            catch (Exception exception) {
                a.error("\u6267\u884c\u5237\u65b0\u5ba2\u6237\u7aeftoken\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)exception);
            }
        }, l2);
    }

    @Autowired(required=false)
    public void setUserSourceProvider(UserSourceProvider userSourceProvider) {
        this.c = userSourceProvider;
    }

    @Autowired(required=false)
    public void setoAuth2ClientProvider(OAuth2ClientProvider oAuth2ClientProvider) {
        this.d = oAuth2ClientProvider;
    }
}

