/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.sso.configurer;

import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.SsoProvider;
import com.elitescloud.cloudt.authorization.sdk.sso.TicketResolver;
import com.elitescloud.cloudt.authorization.sdk.sso.configurer.filter.CloudtSsoFilter;
import com.elitescloud.cloudt.authorization.sdk.sso.impl.CookieTicketResolver;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class SsoFilterConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SsoFilterConfigurer<H>, H> {
    private static final Logger a = LoggerFactory.getLogger(SsoFilterConfigurer.class);
    private final AuthorizationSdkProperties b;
    private Class<? extends Filter> c;
    private SsoProvider d;
    private TicketResolver e;
    private AuthenticationSuccessHandler f;
    private AuthenticationFailureHandler g;

    public SsoFilterConfigurer(AuthorizationSdkProperties authorizationSdkProperties) {
        this.b = authorizationSdkProperties;
    }

    public void init(H h2) throws Exception {
        if (this.e == null) {
            this.e = new CookieTicketResolver(this.b);
        }
        super.init(h2);
    }

    public void configure(H h2) throws Exception {
        if (!this.b.getSso().getEnabled().booleanValue()) {
            return;
        }
        CloudtSsoFilter cloudtSsoFilter = new CloudtSsoFilter(this.b);
        if (this.d == null) {
            a.warn("SsoProvider \u4e3a\u7a7a");
        }
        cloudtSsoFilter.setSsoProvider(this.d);
        cloudtSsoFilter.setTicketResolver(this.e);
        cloudtSsoFilter.setAuthenticationSuccessHandler(this.f);
        if (this.c == null) {
            this.c = AbstractPreAuthenticatedProcessingFilter.class;
        }
        h2.addFilterBefore((Filter)cloudtSsoFilter, this.c);
        super.configure(h2);
    }

    public SsoFilterConfigurer<H> setAddFilterBeforeClass(Class<? extends Filter> clazz) {
        this.c = clazz;
        return this;
    }

    public SsoFilterConfigurer<H> setSsoProvider(SsoProvider ssoProvider) {
        this.d = ssoProvider;
        return this;
    }

    public SsoFilterConfigurer<H> setTicketResolver(TicketResolver ticketResolver) {
        this.e = ticketResolver;
        return this;
    }

    public SsoFilterConfigurer<H> setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.f = authenticationSuccessHandler;
        return this;
    }

    public SsoFilterConfigurer<H> setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.g = authenticationFailureHandler;
        return this;
    }
}

