/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.sso.configurer.filter;

import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.SsoProvider;
import com.elitescloud.cloudt.authorization.sdk.sso.TicketResolver;
import com.elitescloud.cloudt.authorization.sdk.sso.common.TicketAuthentication;
import com.elitescloud.cloudt.authorization.sdk.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.authorization.sdk.util.AuthorizationServerHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class CloudtSsoFilter
extends OncePerRequestFilter {
    private static final Logger a = LoggerFactory.getLogger(CloudtSsoFilter.class);
    private final AuthorizationSdkProperties b;
    private TicketResolver c;
    private SsoProvider d;
    private AuthenticationSuccessHandler e;
    private AuthenticationFailureHandler f;
    private final AuthorizationServerHelper g = AuthorizationServerHelper.getInstance();
    private final ObjectMapper h = new ObjectMapper();

    public CloudtSsoFilter(AuthorizationSdkProperties authorizationSdkProperties) {
        this.b = authorizationSdkProperties;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.a(httpServletRequest)) {
            this.a(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.b(httpServletRequest)) {
            this.b(httpServletRequest, httpServletResponse);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void setSsoProvider(SsoProvider ssoProvider) {
        this.d = ssoProvider;
    }

    public void setTicketResolver(TicketResolver ticketResolver) {
        this.c = ticketResolver;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.e = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.f = authenticationFailureHandler;
    }

    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.d != null && this.d.isAuthenticated(httpServletRequest)) {
            this.a(httpServletResponse, false, null);
            return;
        }
        UserInfoDTO userInfoDTO = null;
        String string = this.c.obtain(httpServletRequest);
        if (StringUtils.hasText((String)string)) {
            userInfoDTO = this.a(string);
        }
        if (userInfoDTO == null) {
            this.a(httpServletResponse);
            return;
        }
        TicketAuthentication ticketAuthentication = new TicketAuthentication(string, userInfoDTO);
        if (this.d != null) {
            try {
                ticketAuthentication = this.d.authentication(httpServletRequest, httpServletResponse, ticketAuthentication);
            }
            catch (Exception exception) {
                a.info("\u8ba4\u8bc1\u5931\u8d25\uff1a{}", (Object)exception.getMessage());
                this.a(httpServletResponse);
                return;
            }
        } else {
            ticketAuthentication = new TicketAuthentication(string, userInfoDTO, Collections.emptyList());
        }
        if (ticketAuthentication.isAuthenticated()) {
            if (this.e != null) {
                this.e.onAuthenticationSuccess(httpServletRequest, httpServletResponse, (Authentication)ticketAuthentication);
            }
        } else if (this.f != null) {
            this.f.onAuthenticationFailure(httpServletRequest, httpServletResponse, (AuthenticationException)new AuthenticationServiceException("\u8ba4\u8bc1\u5931\u8d25"));
        }
        this.c.save(httpServletRequest, httpServletResponse, string);
        this.a(httpServletResponse, true, ticketAuthentication.getToken());
    }

    private void b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.c.obtain(httpServletRequest);
        if (this.d != null) {
            this.d.clearToken(httpServletRequest, httpServletResponse, string);
        }
        if (StringUtils.hasText((String)string)) {
            String string2 = httpServletRequest.getParameter("server");
            if (!"true".equalsIgnoreCase(string2)) {
                this.g.revokeTicket(this.b.getAuthServer(), string);
            }
            this.c.clear(httpServletRequest, httpServletResponse);
        }
        this.a(httpServletResponse);
    }

    private boolean a(HttpServletRequest httpServletRequest) {
        if (!StringUtils.hasText((String)this.b.getSso().getAuthorizeEndpoint())) {
            a.error("\u5355\u70b9\u767b\u5f55\u62e6\u622a\u5931\u6548\uff0c\u8ba4\u8bc1\u5730\u5740\u672a\u914d\u7f6e\uff01");
            return false;
        }
        return httpServletRequest.getRequestURI().equals(this.b.getSso().getAuthorizeEndpoint());
    }

    private boolean b(HttpServletRequest httpServletRequest) {
        if (!StringUtils.hasText((String)this.b.getSso().getAuthorizeRevokeEndpoint())) {
            a.error("\u5355\u70b9\u767b\u5f55\u7684\u6ce8\u9500\u5730\u5740\u672a\u914d\u7f6e\uff01");
            return false;
        }
        return httpServletRequest.getRequestURI().equals(this.b.getSso().getAuthorizeRevokeEndpoint());
    }

    private UserInfoDTO a(String string) {
        UserInfoDTO userInfoDTO = null;
        try {
            userInfoDTO = this.g.ticket2UserInfo(this.b.getAuthServer(), string);
        }
        catch (Exception exception) {
            this.logger.error((Object)"\u5355\u70b9\u767b\u5f55\u5f02\u5e38\uff1a", (Throwable)exception);
        }
        if (userInfoDTO == null) {
            a.info("\u672a\u89e3\u6790\u5230\u6709\u6548\u7528\u6237\u4fe1\u606f\uff0c\u9700\u767b\u5f55");
        }
        return userInfoDTO;
    }

    private void a(HttpServletResponse httpServletResponse, boolean bl, Serializable serializable) throws IOException {
        httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setStatus(HttpStatus.OK.value());
        try (PrintWriter printWriter = httpServletResponse.getWriter();){
            String string = this.h.writeValueAsString((Object)new AuthorizedResult(true, bl ? "SSO\u670d\u52a1\u5df2\u8ba4\u8bc1" : "\u670d\u52a1\u5df2\u8ba4\u8bc1", serializable));
            printWriter.write(string);
        }
    }

    private void a(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
        try (PrintWriter printWriter = httpServletResponse.getWriter();){
            String string = this.h.writeValueAsString((Object)new AuthorizedResult(false, "\u8bf7\u91cd\u65b0\u767b\u5f55"));
            printWriter.write(string);
        }
    }

    static class AuthorizedResult
    implements Serializable {
        private static final long serialVersionUID = -4599981681764185389L;
        private final boolean authorized;
        private final String msg;
        private final Serializable token;

        public AuthorizedResult() {
            this.authorized = false;
            this.msg = "";
            this.token = null;
        }

        public AuthorizedResult(boolean bl, String string) {
            this.authorized = bl;
            this.msg = string;
            this.token = null;
        }

        public AuthorizedResult(boolean bl, String string, Serializable serializable) {
            this.authorized = bl;
            this.msg = string;
            this.token = serializable;
        }

        public boolean a() {
            return this.authorized;
        }

        public String getMsg() {
            return this.msg;
        }

        public Serializable getToken() {
            return this.token;
        }
    }
}

