/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.sso.impl;

import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.TicketResolver;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CookieTicketResolver
implements TicketResolver {
    private static final Logger a = LoggerFactory.getLogger(CookieTicketResolver.class);
    private final AuthorizationSdkProperties b;

    public CookieTicketResolver(AuthorizationSdkProperties authorizationSdkProperties) {
        this.b = authorizationSdkProperties;
    }

    @Override
    public String obtain(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("ticket");
        if (StringUtils.hasText((String)string)) {
            return string;
        }
        string = httpServletRequest.getHeader("X-Auth-ticket");
        if (StringUtils.hasText((String)string)) {
            return string;
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null || cookieArray.length == 0) {
            return null;
        }
        for (Cookie cookie : cookieArray) {
            if (!"cloudt_ticket".equals(cookie.getName())) continue;
            a.info("\u83b7\u53d6\u5230ticket\uff1a{}", (Object)cookie.getValue());
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void save(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        AuthorizationSdkProperties.Sso sso = this.b.getSso();
        this.a(string, sso.getCookieDomains(), sso.getCookieHttpOnly(), sso.getCookieSecure(), httpServletResponse);
    }

    @Override
    public void clear(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.a(this.b.getSso().getCookieDomains(), httpServletResponse);
    }

    private void a(String string, Set<String> set, boolean bl, boolean bl2, HttpServletResponse httpServletResponse) {
        if (CollectionUtils.isEmpty(set)) {
            a.error("sso ticket\u5199\u5165cookie\u5931\u8d25\uff0c\u57df\u540d\u672a\u914d\u7f6e");
            return;
        }
        List list = set.stream().map(string2 -> {
            Cookie cookie = new Cookie("cloudt_ticket", string);
            cookie.setDomain(string2);
            cookie.setPath("/");
            cookie.setHttpOnly(bl);
            cookie.setSecure(bl2);
            return cookie;
        }).collect(Collectors.toList());
        for (Cookie cookie : list) {
            httpServletResponse.addCookie(cookie);
        }
    }

    private void a(Set<String> set, HttpServletResponse httpServletResponse) {
        if (CollectionUtils.isEmpty(set)) {
            a.error("sso ticket\u6e05\u7406cookie\u5931\u8d25\uff0c\u57df\u540d\u672a\u914d\u7f6e");
            return;
        }
        List list = set.stream().map(string -> {
            Cookie cookie = new Cookie("cloudt_ticket", null);
            cookie.setDomain(string);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            return cookie;
        }).collect(Collectors.toList());
        for (Cookie cookie : list) {
            httpServletResponse.addCookie(cookie);
        }
    }
}

