/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.util;

import com.elitescloud.cloudt.authorization.sdk.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestTemplateFactory {
    private RestTemplateFactory() {
    }

    public static RestTemplate instance() {
        return RestTemplateFactory.instance(null);
    }

    public static RestTemplate instance(Function<RestTemplateBuilder, RestTemplateBuilder> function) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(RestTemplateFactory::a).customizers(new RestTemplateCustomizer[]{RestTemplateFactory.b()});
        if (function != null) {
            restTemplateBuilder = function.apply(restTemplateBuilder);
        }
        return restTemplateBuilder.build();
    }

    private static ClientHttpRequestFactory a() {
        SSLContextBuilder sSLContextBuilder;
        SSLConnectionSocketFactory sSLConnectionSocketFactory = null;
        try {
            sSLContextBuilder = new SSLContextBuilder();
            sSLContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sSLContextBuilder = HttpClients.custom();
        sSLContextBuilder.setSSLSocketFactory(sSLConnectionSocketFactory);
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpComponentsClientHttpRequestFactory.setHttpClient((HttpClient)sSLContextBuilder.build());
        httpComponentsClientHttpRequestFactory.setConnectTimeout((int)Duration.ofSeconds(10L).toMillis());
        httpComponentsClientHttpRequestFactory.setReadTimeout((int)Duration.ofSeconds(60L).toMillis());
        return httpComponentsClientHttpRequestFactory;
    }

    private static RestTemplateCustomizer b() {
        ObjectMapper objectMapper = ObjectMapperFactory.instance();
        return restTemplate -> {
            for (HttpMessageConverter httpMessageConverter : restTemplate.getMessageConverters()) {
                if (!(httpMessageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
                ((MappingJackson2HttpMessageConverter)httpMessageConverter).setObjectMapper(objectMapper);
                return;
            }
            restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter(objectMapper));
        };
    }
}

