/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.common.OpenApiException;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RestTemplateHelper.class);
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    private RestTemplateHelper(RestTemplate restTemplate, ObjectMapper objectMapper) {
        Assert.notNull((Object)restTemplate, (String)"restTemplate\u4e3a\u7a7a");
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper == null ? ObjectMapperFactory.instance() : objectMapper;
    }

    public static RestTemplateHelper instance(@NotNull RestTemplate restTemplate) {
        return new RestTemplateHelper(restTemplate, null);
    }

    public static RestTemplateHelper instance(@NotNull RestTemplate restTemplate, ObjectMapper objectMapper) {
        return new RestTemplateHelper(restTemplate, objectMapper);
    }

    public <T> T exchange(@NotBlank String url, @NotNull HttpMethod httpMethod, HttpEntity<?> httpEntity, ParameterizedTypeReference<T> responseType, Object ... uriParameters) {
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, httpMethod, httpEntity, responseType, this.normalizeUriParameters(uriParameters));
        }
        catch (RestClientException e) {
            LOG.error("{}\u8c03\u7528\u5931\u8d25\uff1a{}", new Object[]{url, e.getMessage(), e});
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff1a{}, {}", (Object)url, (Object)response);
            throw new OpenApiException("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25", response.getStatusCodeValue());
        }
        LOG.info("\u63a5\u53e3{}\u8c03\u7528\u6210\u529f", (Object)url);
        return (T)response.getBody();
    }

    public <T> T exchangeSafely(@NotBlank String url, @NotNull HttpMethod httpMethod, HttpEntity<?> httpEntity, TypeReference<T> responseType, Object ... uriParameters) {
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, httpMethod, httpEntity, String.class, this.normalizeUriParameters(uriParameters));
        }
        catch (RestClientException e) {
            LOG.error("{}\u8c03\u7528\u5931\u8d25\uff1a{}", new Object[]{url, e.getMessage(), e});
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff1a{}, {}", (Object)url, (Object)response);
            throw new OpenApiException("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25\uff1a" + (String)response.getBody(), response.getStatusCodeValue());
        }
        LOG.info("\u63a5\u53e3{}\u8c03\u7528\u6210\u529f", (Object)url);
        if (!StringUtils.hasText((String)((String)response.getBody()))) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue((String)response.getBody(), responseType);
        }
        catch (JsonProcessingException e) {
            LOG.error("\u54cd\u5e94\u7ed3\u679c\u8f6c\u6362\u5f02\u5e38\uff1a{}", response.getBody(), (Object)e);
            throw new IllegalArgumentException("\u54cd\u5e94\u7ed3\u679c\u8f6c\u6362\u5f02\u5e38", e);
        }
    }

    private Object[] normalizeUriParameters(Object[] parameters) {
        if (parameters == null) {
            return new Object[0];
        }
        if (parameters.length == 0) {
            return parameters;
        }
        Object[] result = new Object[parameters.length];
        Object param2 = null;
        for (Object param2 : parameters) {
            result[i] = param2 == null ? "" : param2;
        }
        return result;
    }
}

