package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.boot.auth.client.CloudtAuthClient;
import com.elitescloud.boot.auth.client.CloudtAuthProperties;
import com.elitescloud.boot.auth.client.common.AuthClientConstant;
import com.elitescloud.boot.auth.client.model.OAuthToken;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/**
 * 默认的token提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/22
 */
public class DefaultOAuthTokenProvider implements OAuthTokenProvider {

    private final CloudtAuthClient authClient;
    private final CloudtAuthProperties authProperties;

    private OAuthToken authToken;

    public DefaultOAuthTokenProvider(CloudtAuthClient authClient, CloudtAuthProperties authProperties) {
        this.authClient = authClient;
        this.authProperties = authProperties;
    }

    @Override
    public OAuthToken getToken() {
        if (authToken == null) {
            // 如果不存在则请求获取
            authToken = this.requestToken();
        }

        return authToken;
    }

    @Override
    public OAuthToken refresh() {
        authToken = this.requestToken();
        OAuthTokenHolder.setToken(authToken);
        return authToken;
    }

    private OAuthToken requestToken() {
        // 组织请求参数
        MultiValueMap<String, Object> postParam = new LinkedMultiValueMap<>(8);
        postParam.add("grant_type", AuthClientConstant.AUTH_GRANT_TYPE);
        postParam.add("client_id", authProperties.getClientId());
        postParam.add("client_secret", authProperties.getClientSecret());

        return authClient.exchange(AuthClientConstant.URI_AUTH_TOKEN,
                HttpMethod.POST, postParam, new ParameterizedTypeReference<>() {
                });
    }
}
