/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config;

import com.elitescloud.boot.auth.client.CloudtAuthClient;
import com.elitescloud.boot.auth.client.CloudtAuthProperties;
import com.elitescloud.boot.auth.client.config.support.DefaultOAuthTokenProvider;
import com.elitescloud.boot.auth.client.config.support.OAuthTokenProvider;
import com.elitescloud.boot.auth.client.config.support.ObtainTokenTask;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableConfigurationProperties(value={CloudtAuthProperties.class})
@EnableScheduling
public class CloudtAuthClientAutoConfiguration {
    private final CloudtAuthProperties authProperties;

    public CloudtAuthClientAutoConfiguration(CloudtAuthProperties authProperties) {
        this.authProperties = authProperties;
    }

    @Bean
    public CloudtAuthClient cloudtAuthClient() {
        return new CloudtAuthClient(this.authProperties);
    }

    @Bean
    public OAuthTokenProvider oAuthTokenProviderDefault(CloudtAuthClient authClient) {
        return new DefaultOAuthTokenProvider(authClient, this.authProperties);
    }

    @Bean
    public ObtainTokenTask obtainTokenTask(OAuthTokenProvider authTokenProvider) {
        return new ObtainTokenTask(authTokenProvider, this.authProperties);
    }
}

