/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.boot.auth.client.CloudtAuthProperties;
import com.elitescloud.boot.auth.client.config.support.OAuthTokenProvider;
import com.elitescloud.boot.auth.client.model.OAuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class ObtainTokenTask
implements SchedulingConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(ObtainTokenTask.class);
    private final OAuthTokenProvider authTokenProvider;
    private final CloudtAuthProperties authProperties;

    public ObtainTokenTask(OAuthTokenProvider authTokenProvider, CloudtAuthProperties authProperties) {
        this.authTokenProvider = authTokenProvider;
        this.authProperties = authProperties;
    }

    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        LOG.info("\u5237\u65b0token\u95f4\u9694\uff1a{}min", (Object)this.authProperties.getRefreshTokenInterval().toMinutes());
        taskRegistrar.addFixedDelayTask(this::refreshToken, this.authProperties.getRefreshTokenInterval().toMillis());
    }

    private void refreshToken() {
        try {
            OAuthToken token = this.authTokenProvider.refresh();
            if (token == null) {
                LOG.error("\u5237\u65b0token\u5931\u8d25");
                return;
            }
            LOG.info("token\u5237\u65b0\u6210\u529f\uff1a{} {}", (Object)token.getTokenType(), (Object)token.getAccessToken());
        }
        catch (Throwable e) {
            LOG.error("\u5237\u65b0token\u5f02\u5e38\uff1a", e);
        }
    }
}

