/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.factory.provider;

import com.elitescloud.boot.auth.factory.common.AuthClientProvider;
import com.elitescloud.boot.auth.factory.common.AuthResult;
import com.elitescloud.boot.auth.factory.common.constant.TokenPositionEnum;
import com.elitescloud.boot.auth.factory.provider.properties.BasicAuthProperty;
import com.elitescloud.boot.auth.util.AuthorizationUtil;
import java.io.IOException;
import java.util.Collections;

public class BasicAuthClientProvider
implements AuthClientProvider<BasicAuthProperty> {
    @Override
    public String code() {
        return "basic";
    }

    @Override
    public String name() {
        return "\u8d26\u6237\u540d\u548c\u5bc6\u7801";
    }

    @Override
    public Class<BasicAuthProperty> propertyClass() {
        return BasicAuthProperty.class;
    }

    @Override
    public AuthResult authenticate(BasicAuthProperty property) {
        String token = null;
        try {
            token = AuthorizationUtil.encodeBasicAuth((String)property.getUsername(), (String)property.getPassword());
        }
        catch (IOException e) {
            throw new RuntimeException("\u52a0\u5bc6\u8d26\u6237\u540d\u548c\u5bc6\u7801\u5f02\u5e38", e);
        }
        AuthResult result = new AuthResult();
        result.setTokenPosition(TokenPositionEnum.HEADER);
        result.setTokenName("Authorization");
        result.setTokenValue(token);
        result.setTtl(null);
        result.setExtra(Collections.emptyMap());
        return result;
    }
}

