package com.elitescloud.boot.auth.factory.provider;

import com.elitescloud.boot.auth.factory.common.AuthClientProvider;
import com.elitescloud.boot.auth.factory.common.AuthResult;
import com.elitescloud.boot.auth.factory.common.constant.TokenPositionEnum;
import com.elitescloud.boot.auth.factory.provider.properties.ApiKeyAuthProperty;
import com.elitescloud.boot.util.ObjUtil;

/**
 * ApiKey的认证方式.
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/26 周一
 */
public class ApiKeyAuthClientProvider implements AuthClientProvider<ApiKeyAuthProperty> {

    @Override
    public String code() {
        return "apiKey";
    }

    @Override
    public String name() {
        return "API Key";
    }

    @Override
    public Class<ApiKeyAuthProperty> propertyClass() {
        return ApiKeyAuthProperty.class;
    }

    @Override
    public AuthResult authenticate(ApiKeyAuthProperty property) {
        AuthResult result = new AuthResult();
        result.setTokenPosition(ObjUtil.defaultIfNull(property.getPosition(), TokenPositionEnum.HEADER));
        result.setTokenName(property.getKey());
        result.setTokenValue(property.getValue());

        return result;
    }
}
