package com.elitescloud.boot.auth.factory.common;

/**
 * 认证客户端.
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/23 周五
 */
public interface AuthClientProvider<T extends BaseAuthProperty> {

    /**
     * 编码
     * <p>
     * 需唯一
     *
     * @return 认证客户端编码
     */
    String code();

    /**
     * 认名称
     *
     * @return 认证客户端名称
     */
    String name();

    /**
     * 属性类
     *
     * @return 认证客户端配置属性类
     */
    Class<T> propertyClass();

    /**
     * 认证
     *
     * @param property 认证配置
     * @return 认证结果
     */
    AuthResult authenticate(T property);
}
