package com.elitescloud.boot.auth.factory.provider;

import com.elitescloud.boot.auth.factory.common.AuthClientProvider;
import com.elitescloud.boot.auth.factory.common.AuthResult;
import com.elitescloud.boot.auth.factory.common.BaseAuthProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 无需认证.
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/23 周五
 */
public class NoopAuthClientProvider implements AuthClientProvider<BaseAuthProperty> {
    private static final Logger logger = LoggerFactory.getLogger(NoopAuthClientProvider.class);

    @Override
    public String code() {
        return "noop";
    }

    @Override
    public String name() {
        return "无需认证";
    }

    @Override
    public Class<BaseAuthProperty> propertyClass() {
        return BaseAuthProperty.class;
    }

    @Override
    public AuthResult authenticate(BaseAuthProperty property) {
        logger.info("无需认证");
        return null;
    }
}
