/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.factory.common;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.factory.common.AuthClientProvider;
import com.elitescloud.boot.auth.factory.common.AuthResult;
import com.elitescloud.boot.auth.factory.common.BaseAuthProperty;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthClientHolder {
    private static final Logger logger = LoggerFactory.getLogger(AuthClientHolder.class);
    private static List<AuthClientProvider<?>> authClientProviders;

    public static List<CodeNameParam> getAuthClientTypes() {
        return AuthClientHolder.getAuthClientProviders().stream().map(t -> new CodeNameParam(t.code(), t.name())).collect(Collectors.toList());
    }

    public static AuthResult authenticate(@NotBlank String authClientType, @NotBlank String authPropertyJson) {
        logger.info("\u8ba4\u8bc1\u7c7b\u578b\uff1a{}", (Object)authClientType);
        AuthClientProvider<?> authClientProvider = AuthClientHolder.getAuthClientProvider(authClientType);
        Assert.notNull(authClientProvider, (String)"\u8ba4\u8bc1\u7c7b\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        BaseAuthProperty property = (BaseAuthProperty)JSONUtil.json2Obj((String)authPropertyJson, authClientProvider.propertyClass(), (boolean)true, () -> "\u8ba4\u8bc1\u53c2\u6570\u683c\u5f0f\u6709\u8bef");
        return AuthClientHolder.execAuth(authClientProvider, property);
    }

    public static AuthResult authenticate(@NotBlank String authClientType, @NotNull BaseAuthProperty authProperty) {
        logger.info("\u8ba4\u8bc1\u7c7b\u578b\uff1a{}", (Object)authClientType);
        AuthClientProvider<?> authClientProvider = AuthClientHolder.getAuthClientProvider(authClientType);
        Assert.notNull(authClientProvider, (String)"\u8ba4\u8bc1\u7c7b\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isAssignable(authClientProvider.propertyClass(), authProperty.getClass(), (String)"\u8ba4\u8bc1\u53c2\u6570\u683c\u5f0f\u6709\u8bef", (Object[])new Object[0]);
        return AuthClientHolder.execAuth(authClientProvider, authProperty);
    }

    private static AuthResult execAuth(AuthClientProvider authClientProvider, BaseAuthProperty authProperty) {
        AuthResult authResult;
        RedisUtils redisUtils = null;
        if (CharSequenceUtil.isNotBlank((CharSequence)authProperty.getPropKey()) && (authResult = (AuthResult)(redisUtils = (RedisUtils)SpringContextHolder.getBean(RedisUtils.class)).get(authProperty.getPropKey())) != null) {
            return authResult;
        }
        authResult = authClientProvider.authenticate(authProperty);
        if (authResult != null && authResult.getTtl() != null && CharSequenceUtil.isNotBlank((CharSequence)authProperty.getPropKey())) {
            redisUtils.set(authProperty.getPropKey(), (Object)authResult, authResult.getTtl().toSeconds(), TimeUnit.SECONDS);
        }
        return authResult;
    }

    private static AuthClientProvider<?> getAuthClientProvider(String authClientType) {
        for (AuthClientProvider<?> authClientProvider : AuthClientHolder.getAuthClientProviders()) {
            if (!authClientProvider.code().equals(authClientType)) continue;
            return authClientProvider;
        }
        return null;
    }

    private static List<AuthClientProvider<?>> getAuthClientProviders() {
        if (authClientProviders == null) {
            authClientProviders = new ArrayList();
            ServiceLoader.load(AuthClientProvider.class).forEach(authClientProviders::add);
        }
        return authClientProviders;
    }
}

