/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.cas.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.cas.model.AuthClientUserDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.provider.config.properties.TokenProperties;
import com.elitescloud.boot.auth.provider.provider.DefaultTokenPropertiesProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasTokenPropertiesProvider
extends DefaultTokenPropertiesProvider {
    private static final Logger log = LoggerFactory.getLogger(CasTokenPropertiesProvider.class);
    private final AuthorizationProperties authorizationProperties;
    private final UserTransferHelper userTransferHelper;

    public CasTokenPropertiesProvider(AuthorizationProperties authorizationProperties, UserTransferHelper userTransferHelper) {
        super(authorizationProperties);
        this.authorizationProperties = authorizationProperties;
        this.userTransferHelper = userTransferHelper;
        log.info("CAS Client token configuration will be used");
    }

    @Override
    public TokenProperties get() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return this.defaultTokenProperties();
        }
        String clientId = (String)request.getAttribute("cloudtClientId");
        if (CharSequenceUtil.isBlank((CharSequence)clientId)) {
            return this.defaultTokenProperties();
        }
        Result result = this.userTransferHelper.validateClientUser(clientId, null);
        if (result.getData() == null) {
            throw new AuthorizationException(result.getMsg());
        }
        TokenProperties tokenProperties = new TokenProperties();
        tokenProperties.setTokenTtl(((AuthClientUserDTO)result.getData()).getTokenTtl());
        tokenProperties.setRefreshTokenTtl(((AuthClientUserDTO)result.getData()).getRefreshTokenTtl());
        return tokenProperties;
    }

    private TokenProperties defaultTokenProperties() {
        TokenProperties tokenProperties = new TokenProperties();
        tokenProperties.setTokenTtl(this.authorizationProperties.getTokenTtl());
        tokenProperties.setRefreshTokenTtl(this.authorizationProperties.getRefreshTokenTtl());
        return tokenProperties;
    }
}

