/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.cas.AuthorizeCacheable;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientTemplate;
import com.elitescloud.boot.auth.cas.provider.PwdStrategyTransferHelper;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.provider.cas.controller.CasSupportController;
import com.elitescloud.boot.auth.provider.cas.support.CasLoginSupportProvider;
import com.elitescloud.boot.auth.provider.cas.support.CasTokenPropertiesProvider;
import com.elitescloud.boot.auth.provider.provider.PwdExpiredTimeProvider;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.auth.provider.security.TokenPropertiesProvider;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@ConditionalOnProperty(prefix="elitesland.authorization.sdk.cas-client", name={"enabled"}, havingValue="true")
class CloudtCasClientConfig {
    private static final Logger log = LogManager.getLogger(CloudtCasClientConfig.class);
    private final AuthorizationSdkProperties sdkProperties;

    public CloudtCasClientConfig(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    @Bean
    public CasSupportController oAuth2LoginSupportController(CasLoginSupportProvider supportProvider) {
        return new CasSupportController(supportProvider);
    }

    @Bean
    @Primary
    public CasLoginSupportProvider casLoginSupportProvider(@Autowired(required=false) OAuth2ClientTemplate oAuth2ClientTemplate, @Autowired(required=false) InternalAuthenticationGranter internalAuthenticationGranter) {
        return new CasLoginSupportProvider(this.sdkProperties, oAuth2ClientTemplate, internalAuthenticationGranter);
    }

    @Bean
    public AuthenticationCallable authenticationCallableCasClient(AuthorizationSdkProperties sdkProperties) {
        final String authUrl = sdkProperties.getAuthServer();
        return new AuthenticationCallable(){

            public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, @Nullable Authentication authentication, @NotNull AuthenticationException exception) {
                log.info("\u7528\u6237\u8ba4\u8bc1\u5f02\u5e38\uff1a", (Throwable)exception);
                if (exception instanceof UsernameNotFoundException || exception instanceof AccountStatusException) {
                    UserTransferHelper help = UserTransferHelper.getInstance((String)authUrl);
                    if (authentication instanceof InternalAuthenticationGranter.InternalAuthenticationToken) {
                        Result result;
                        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = (InternalAuthenticationGranter.InternalAuthenticationToken)authentication;
                        Long userId = null;
                        if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.USER_ID) {
                            userId = Long.parseLong(authenticationToken.getId());
                        } else if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.USERNAME) {
                            AuthUserDTO user = (AuthUserDTO)help.getUserByUsername(authenticationToken.getId()).getData();
                            if (user == null) {
                                log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff0c\u8d26\u53f7{}\u4e0d\u5b58\u5728", (Object)authenticationToken.getId());
                                return;
                            }
                            userId = user.getId();
                        } else if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.MOBILE) {
                            result = help.getUserIdByMobile(List.of(authenticationToken.getId()));
                            if (result.getData() == null || ((HashMap)result.getData()).isEmpty()) {
                                log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff0c{}", (Object)result.getMsg());
                                return;
                            }
                            userId = (Long)((HashMap)result.getData()).get(authenticationToken.getId());
                        } else if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.EMAIL) {
                            result = help.getUserIdByEmail(List.of(authenticationToken.getId()));
                            if (result.getData() == null || ((HashMap)result.getData()).isEmpty()) {
                                log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff0c{}", (Object)result.getMsg());
                                return;
                            }
                            userId = (Long)((HashMap)result.getData()).get(authenticationToken.getId());
                        }
                        if (userId != null) {
                            result = help.updateEnabled(userId.longValue(), false);
                            if (Boolean.FALSE.equals(result.getSuccess())) {
                                log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff1a" + result.getMsg());
                            }
                            return;
                        }
                        log.error("\u6682\u4e0d\u652f\u6301\u81ea\u52a8\u7981\u7528\u8d26\u53f7\uff1a" + authenticationToken.getIdType());
                    }
                }
            }
        };
    }

    @Bean
    public TokenPropertiesProvider casTokenPropertiesProvider(AuthorizationProperties authorizationProperties) {
        return new CasTokenPropertiesProvider(authorizationProperties, UserTransferHelper.getInstance((String)this.sdkProperties.getAuthServer()));
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    public AuthorizeCacheable authorizeCacheableRedis(final RedisHelper redisHelper) {
        return new AuthorizeCacheable(){
            private static final String KEY_PREFIX = "cas:authorize:";

            public void setCache(String reqId, AuthorizeDTO authorizeDTO) {
                try {
                    redisHelper.execute(redisUtils -> redisUtils.set(KEY_PREFIX + reqId, (Object)authorizeDTO, 7L, TimeUnit.DAYS));
                }
                catch (Exception e) {
                    throw new IllegalStateException("\u767b\u5f55\u5f02\u5e38", e);
                }
            }

            public AuthorizeDTO get(String reqId) {
                try {
                    return (AuthorizeDTO)redisHelper.execute(redisUtils -> redisUtils.get(KEY_PREFIX + reqId));
                }
                catch (Exception e) {
                    throw new IllegalStateException("\u767b\u5f55\u5f02\u5e38", e);
                }
            }
        };
    }

    @Bean
    public AuthenticationCheckService pwdExpiredTimeProvider() {
        return new PwdExpiredTimeProvider(this.sdkProperties, PwdStrategyTransferHelper.getInstance((String)this.sdkProperties.getAuthServer()));
    }
}

